/*
 * Decompiled with CFR 0.152.
 */
package com.preference.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.XmlResourceParser;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.XmlRes;
import android.util.Log;
import com.google.gson.Gson;
import com.preference.utils.WrongValueException;
import java.util.HashMap;
import java.util.Map;

public class PreferenceCreator {
    private static String TAG = "PowerPreference";
    private String name;
    private Context context;
    private SharedPreferences sharedPreferences;
    private Map<String, Object> defaults;

    public PreferenceCreator(Context context, Map<String, Object> defaults) {
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.context = context;
        this.defaults = defaults;
        this.name = "default";
    }

    public PreferenceCreator(String name, Context context, Map<String, Object> defaults) {
        this.sharedPreferences = context.getSharedPreferences(name, 0);
        this.context = context;
        this.defaults = defaults;
        this.name = name;
    }

    public PreferenceCreator put(String key, int value) {
        this.sharedPreferences.edit().putInt(key, value).apply();
        return this;
    }

    public PreferenceCreator put(String key, long value) {
        this.sharedPreferences.edit().putLong(key, value).apply();
        return this;
    }

    public PreferenceCreator put(String key, float value) {
        this.sharedPreferences.edit().putFloat(key, value).apply();
        return this;
    }

    public PreferenceCreator put(String key, double value) {
        this.sharedPreferences.edit().putString(key, String.valueOf(value)).apply();
        return this;
    }

    public PreferenceCreator put(String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).apply();
        return this;
    }

    public PreferenceCreator put(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).apply();
        return this;
    }

    public PreferenceCreator put(String key, Object value) {
        String json = new Gson().toJson(value);
        this.sharedPreferences.edit().putString(key, json).apply();
        return this;
    }

    public PreferenceCreator putInt(String key, int value) {
        this.sharedPreferences.edit().putInt(key, value).apply();
        return this;
    }

    public PreferenceCreator putLong(String key, long value) {
        this.sharedPreferences.edit().putLong(key, value).apply();
        return this;
    }

    public PreferenceCreator putFloat(String key, float value) {
        this.sharedPreferences.edit().putFloat(key, value).apply();
        return this;
    }

    public PreferenceCreator putDouble(String key, double value) {
        this.sharedPreferences.edit().putString(key, String.valueOf(value)).apply();
        return this;
    }

    public PreferenceCreator putBoolean(String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).apply();
        return this;
    }

    public PreferenceCreator putString(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).apply();
        return this;
    }

    public PreferenceCreator putObject(String key, Object value) {
        String json = new Gson().toJson(value);
        this.sharedPreferences.edit().putString(key, json).apply();
        return this;
    }

    public boolean contains(String key) {
        return this.sharedPreferences.contains(key);
    }

    public void remove(String key) {
        this.sharedPreferences.edit().remove(key).apply();
    }

    public void clear() {
        this.sharedPreferences.edit().clear().apply();
    }

    public Map<String, ?> getData() {
        return this.sharedPreferences.getAll();
    }

    @NonNull
    public String getString(String key) {
        Object value = this.getDefaultValue(key);
        String defaultValue = "";
        if (value != null) {
            defaultValue = String.valueOf(value);
        }
        return this.sharedPreferences.getString(key, defaultValue);
    }

    public String getString(String key, String defValue) {
        return this.sharedPreferences.getString(key, defValue);
    }

    public int getInt(String key) {
        Object value = this.getDefaultValue(key);
        int defaultValue = 0;
        if (value != null) {
            if (value instanceof Integer) {
                defaultValue = (Integer)value;
            } else if (value instanceof String) {
                try {
                    defaultValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    Log.d((String)TAG, (String)("you to must have a {Integer} default value! for the key => {" + key + "}"), (Throwable)e);
                }
            } else {
                Log.d((String)TAG, (String)("you to must have a {Integer} default value! for the key => {" + key + "}"), (Throwable)new WrongValueException(value));
            }
        }
        return this.sharedPreferences.getInt(key, defaultValue);
    }

    public int getInt(String key, int defValue) {
        return this.sharedPreferences.getInt(key, defValue);
    }

    public long getLong(String key) {
        Object value = this.getDefaultValue(key);
        long defaultValue = 0L;
        if (value != null) {
            if (value instanceof Long) {
                defaultValue = (Long)value;
            } else if (value instanceof String) {
                try {
                    defaultValue = Long.parseLong((String)value);
                }
                catch (NumberFormatException e) {
                    Log.d((String)TAG, (String)("you to must have a {Long} default value! for the key => {" + key + "}"), (Throwable)e);
                }
            } else {
                Log.d((String)TAG, (String)("you to must have a {Long} default value! for the key => {" + key + "}"), (Throwable)new WrongValueException(value));
            }
        }
        return this.sharedPreferences.getLong(key, defaultValue);
    }

    public long getLong(String key, long defValue) {
        return this.sharedPreferences.getLong(key, defValue);
    }

    public boolean getBoolean(String key) {
        Object value = this.getDefaultValue(key);
        boolean defaultValue = false;
        if (value != null) {
            if (value instanceof Boolean) {
                defaultValue = (Boolean)value;
            } else if (value instanceof String) {
                defaultValue = Boolean.parseBoolean((String)value);
            } else {
                Log.d((String)TAG, (String)("you to must have a {Boolean} default value! for the key => {" + key + "}"), (Throwable)new WrongValueException(value));
            }
        }
        return this.sharedPreferences.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.sharedPreferences.getBoolean(key, defValue);
    }

    public float getFloat(String key) {
        Object value = this.getDefaultValue(key);
        float defaultValue = 0.0f;
        if (value != null) {
            if (value instanceof Float) {
                defaultValue = ((Float)value).floatValue();
            } else if (value instanceof String) {
                try {
                    defaultValue = Float.parseFloat((String)value);
                }
                catch (NumberFormatException e) {
                    Log.d((String)TAG, (String)("you to must have a {Float} default value! for the key => {" + key + "}"), (Throwable)e);
                }
            } else {
                Log.d((String)TAG, (String)("you to must have a {Float} default value! for the key => {" + key + "}"), (Throwable)new WrongValueException(value));
            }
        }
        return this.sharedPreferences.getFloat(key, defaultValue);
    }

    public float getFloat(String key, float defValue) {
        return this.sharedPreferences.getFloat(key, defValue);
    }

    public <T> T getObject(String key, Class classType, T defValue) {
        String json = this.sharedPreferences.getString(key, "");
        Object value = new Gson().fromJson(json, classType);
        if (value == null) {
            return defValue;
        }
        return (T)value;
    }

    @Nullable
    public <T> T getObject(String key, Class classType) {
        String json = this.sharedPreferences.getString(key, "");
        Object value = new Gson().fromJson(json, classType);
        if (value == null) {
            return (T)this.getDefaultValue(key);
        }
        return (T)value;
    }

    public double getDouble(String key) {
        double value;
        String string = this.sharedPreferences.getString(key, "");
        double defaultDouble = 0.0;
        try {
            value = Double.valueOf(string);
        }
        catch (NumberFormatException exp) {
            Object defaultValue = this.getDefaultValue(key);
            if (defaultValue == null) {
                return 0.0;
            }
            if (defaultValue instanceof Double) {
                defaultDouble = (Double)defaultValue;
            } else if (defaultValue instanceof String) {
                try {
                    defaultDouble = Double.parseDouble((String)defaultValue);
                }
                catch (NumberFormatException e) {
                    Log.d((String)TAG, (String)("you to must have a {Double} default value! for the key => {" + key + "}"), (Throwable)e);
                }
            } else {
                Log.d((String)TAG, (String)("you to must have a {Double} default value! for the key => {" + key + "}"), (Throwable)new WrongValueException(defaultValue));
            }
            return defaultDouble;
        }
        return value;
    }

    public double getDouble(String key, double defValue) {
        String json = this.sharedPreferences.getString(key, "");
        Object value = new Gson().fromJson(json, Double.TYPE);
        if (value == null) {
            return defValue;
        }
        return (Double)value;
    }

    public void setDefaults(Map<String, Object> defaultValues) {
        if (defaultValues == null) {
            return;
        }
        this.defaults.put(this.name, defaultValues);
    }

    public void setDefaults(@XmlRes int xml) {
        try {
            String KEY = "key";
            String VALUE = "value";
            String ENTRY = "entry";
            XmlResourceParser parser = this.context.getResources().getXml(xml);
            int eventType = parser.getEventType();
            String tagName = null;
            String key = null;
            String value = null;
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 2: {
                        tagName = parser.getName();
                        break;
                    }
                    case 4: {
                        if (tagName == null) break;
                        switch (tagName) {
                            case "key": {
                                key = parser.getText();
                                break block1;
                            }
                            case "value": {
                                value = parser.getText();
                                break block1;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("entry")) break;
                        defaultValues.put(key, value);
                        key = null;
                        value = null;
                    }
                }
                eventType = parser.next();
            }
            this.defaults.put(this.name, defaultValues);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)e);
        }
    }

    @Nullable
    private Object getDefaultValue(String key) {
        Map defaultValues = (Map)this.defaults.get(this.name);
        if (defaultValues != null) {
            if (defaultValues.containsKey(key)) {
                return defaultValues.get(key);
            }
            return null;
        }
        return null;
    }
}

