/*
 * Decompiled with CFR 0.152.
 */
package com.algorithmia.algo;

import com.algorithmia.algo.ContentType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import org.apache.commons.codec.binary.Base64;

public final class BodyPart {
    protected String name = "";
    protected String filename = null;
    protected String data = "";
    protected ContentType content_type;
    protected String mime_type = "";
    private final Gson gson = new Gson();

    public BodyPart() {
        this.content_type = ContentType.Void;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public Boolean hasFilename() {
        return this.filename != null;
    }

    public ContentType getContentType() {
        return this.content_type;
    }

    public String getMimeType() {
        return this.mime_type;
    }

    public Object as(Type type) {
        if (this.content_type == ContentType.Void) {
            return null;
        }
        if (this.content_type == ContentType.Text) {
            return this.gson.fromJson((JsonElement)new JsonPrimitive(this.data), type);
        }
        if (this.content_type == ContentType.Json) {
            return this.gson.fromJson(this.data, type);
        }
        if (this.content_type == ContentType.Binary) {
            return Base64.decodeBase64((String)this.data);
        }
        return null;
    }
}

