/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.voice;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.algolia.instantsearch.voice.R;
import java.util.ArrayList;

public class VoiceDialogFragment
extends DialogFragment
implements RecognitionListener {
    public static final String SEPARATOR = "\u2022 ";
    public static final String TAG = "VoiceDialogFragment";
    private String[] suggestions;
    private SpeechRecognizer speechRecognizer;
    private VoiceResultsListener voiceResultsListener;
    private ProgressBar progressBar;
    private TextView hintView;
    private TextView suggestionsView;
    private TextView titleView;
    private boolean listening = false;

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        View content = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.layout_voice_overlay, null);
        this.initViews(content);
        this.setButtonsOnClickListeners(content);
        this.updateSuggestions();
        return new AlertDialog.Builder((Context)this.getActivity()).setView(content).create();
    }

    public void onPause() {
        super.onPause();
        this.stopVoiceRecognition();
    }

    public void onResume() {
        super.onResume();
        this.startVoiceRecognition();
    }

    private void initViews(View content) {
        this.hintView = (TextView)content.findViewById(R.id.hint);
        this.suggestionsView = (TextView)content.findViewById(R.id.suggestions);
        this.titleView = (TextView)content.findViewById(R.id.title);
        this.progressBar = (ProgressBar)content.findViewById(R.id.feedback);
        if (Build.VERSION.SDK_INT <= 21) {
            TypedValue typedValue = new TypedValue();
            if (this.getContext().getTheme().resolveAttribute(R.attr.algolia_voiceOverlayFeedbackColor, typedValue, true)) {
                this.progressBar.getProgressDrawable().setColorFilter(typedValue.data, PorterDuff.Mode.SRC_IN);
            }
        }
    }

    private void setButtonsOnClickListeners(View content) {
        ((Button)content.findViewById(R.id.closeButton)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VoiceDialogFragment.this.dismiss();
            }
        });
        ((Button)content.findViewById(R.id.micButton)).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VoiceDialogFragment.this.listening) {
                    VoiceDialogFragment.this.stopVoiceRecognition();
                } else {
                    VoiceDialogFragment.this.startVoiceRecognition();
                }
            }
        });
    }

    private void startVoiceRecognition() {
        this.listening = true;
        Intent recognizerIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        recognizerIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        recognizerIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
        recognizerIntent.putExtra("android.speech.extra.MAX_RESULTS", 1);
        this.speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)this.getActivity());
        this.speechRecognizer.setRecognitionListener((RecognitionListener)this);
        this.speechRecognizer.startListening(recognizerIntent);
        this.updateSuggestions();
        this.titleView.setText(R.string.voice_search_title);
    }

    private void stopVoiceRecognition() {
        this.listening = false;
        if (this.speechRecognizer != null) {
            this.speechRecognizer.stopListening();
            this.speechRecognizer.destroy();
        }
        this.hintView.setVisibility(0);
        this.progressBar.setVisibility(8);
        this.updateSuggestions();
    }

    public void onReadyForSpeech(Bundle params) {
        Log.d((String)TAG, (String)("onReadyForSpeech:" + params));
    }

    public void onBeginningOfSpeech() {
        Log.d((String)TAG, (String)"onBeginningOfSpeech");
    }

    public void onRmsChanged(float rmsdB) {
        this.progressBar.setVisibility(0);
        this.progressBar.setProgress((int)rmsdB);
    }

    public void onBufferReceived(byte[] buffer) {
        Log.d((String)TAG, (String)("onBufferReceived: " + buffer));
    }

    public void onEndOfSpeech() {
        Log.d((String)TAG, (String)"onEndOfSpeech");
        this.listening = false;
    }

    public void onError(int error) {
        String errorText = this.getErrorMessage(error);
        Log.d((String)TAG, (String)("onError: " + errorText));
        this.stopVoiceRecognition();
        this.titleView.setText(R.string.voice_search_error);
        this.hintView.setVisibility(8);
        this.suggestionsView.setText((CharSequence)errorText);
        this.suggestionsView.setTypeface(null, 1);
    }

    public void onResults(Bundle results) {
        ArrayList matches = results.getStringArrayList("results_recognition");
        StringBuilder b = new StringBuilder();
        for (String match : matches) {
            b.append(match).append("\n");
        }
        this.suggestionsView.setText((CharSequence)b.toString());
        this.suggestionsView.setTypeface(null, 0);
        Log.d((String)TAG, (String)("onResults:" + matches.size() + ": " + b.toString()));
        this.stopVoiceRecognition();
        this.voiceResultsListener.onVoiceResults(matches);
        this.dismiss();
    }

    public void onPartialResults(Bundle partialResults) {
        ArrayList matches = partialResults.getStringArrayList("results_recognition");
        StringBuilder b = new StringBuilder();
        for (String match : matches) {
            b.append(match).append("\n");
        }
        this.hintView.setVisibility(8);
        this.suggestionsView.setText((CharSequence)b.toString());
        this.suggestionsView.setTypeface(null, 2);
        Log.d((String)TAG, (String)("onPartialResults:" + matches.size() + ": " + b.toString()));
    }

    public void onEvent(int eventType, Bundle params) {
        Log.d((String)TAG, (String)"onEvent");
    }

    @NonNull
    private String getErrorMessage(int error) {
        String errorText = "Unknown error.";
        switch (error) {
            case 3: {
                errorText = "Audio recording error.";
                break;
            }
            case 5: {
                errorText = "Other client side errors.";
                break;
            }
            case 9: {
                errorText = "Insufficient permissions";
                break;
            }
            case 2: {
                errorText = "Other network related errors.";
                break;
            }
            case 1: {
                errorText = "Network operation timed out.";
                break;
            }
            case 7: {
                errorText = "No recognition result matched.";
                break;
            }
            case 8: {
                errorText = "RecognitionService busy.";
                break;
            }
            case 4: {
                errorText = "Server sends error status.";
                break;
            }
            case 6: {
                errorText = "No speech input.";
            }
        }
        return errorText;
    }

    public void setSuggestions(String ... suggestions) {
        this.suggestions = suggestions;
        if (this.getView() != null) {
            this.updateSuggestions();
        }
    }

    private void updateSuggestions() {
        Context context = this.getContext();
        if (context != null) {
            this.hintView.setVisibility(0);
            StringBuilder b = new StringBuilder();
            if (this.suggestions != null && this.suggestions.length > 0) {
                for (String s : this.suggestions) {
                    b.append(SEPARATOR).append(s).append("\n");
                }
            }
            this.suggestionsView.setText((CharSequence)b.toString());
        }
    }

    public void setVoiceResultsListener(VoiceResultsListener voiceResultsListener) {
        this.voiceResultsListener = voiceResultsListener;
    }

    public static interface VoiceResultsListener {
        public void onVoiceResults(@NonNull ArrayList<String> var1);
    }
}

