/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.insights;

import android.content.Context;
import com.algolia.instantsearch.insights.InsightsLogger;
import com.algolia.instantsearch.insights.InstantSearchInsightsException;
import com.algolia.instantsearch.insights.database.Database;
import com.algolia.instantsearch.insights.database.DatabaseSharedPreferences;
import com.algolia.instantsearch.insights.event.Event;
import com.algolia.instantsearch.insights.event.EventUploader;
import com.algolia.instantsearch.insights.event.EventUploaderAndroidJob;
import com.algolia.instantsearch.insights.webservice.WebService;
import com.algolia.instantsearch.insights.webservice.WebServiceHttp;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0002 !B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0019J\u001a\u0010\u001a\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0019J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J!\u0010\u001e\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/algolia/instantsearch/insights/Insights;", "", "indexName", "", "eventUploader", "Lcom/algolia/instantsearch/insights/event/EventUploader;", "database", "Lcom/algolia/instantsearch/insights/database/Database;", "webService", "Lcom/algolia/instantsearch/insights/webservice/WebService;", "(Ljava/lang/String;Lcom/algolia/instantsearch/insights/event/EventUploader;Lcom/algolia/instantsearch/insights/database/Database;Lcom/algolia/instantsearch/insights/webservice/WebService;)V", "getDatabase$com_algolia_instantsearch_android_insights", "()Lcom/algolia/instantsearch/insights/database/Database;", "value", "", "loggingEnabled", "getLoggingEnabled", "()Z", "setLoggingEnabled", "(Z)V", "getWebService$com_algolia_instantsearch_android_insights", "()Lcom/algolia/instantsearch/insights/webservice/WebService;", "click", "", "params", "", "conversion", "process", "event", "Lcom/algolia/instantsearch/insights/event/Event;", "view", "view$com_algolia_instantsearch_android_insights", "Companion", "Configuration", "com.algolia.instantsearch-android.insights"})
public final class Insights {
    private boolean loggingEnabled;
    private final String indexName;
    private final EventUploader eventUploader;
    @NotNull
    private final Database database;
    @NotNull
    private final WebService webService;
    @NotNull
    private static final Map<String, Insights> insightsMap;
    public static final Companion Companion;

    public final boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public final void setLoggingEnabled(boolean value) {
        this.loggingEnabled = value;
        Map<String, Boolean> map = InsightsLogger.INSTANCE.getEnabled();
        String string = this.indexName;
        Boolean bl = value;
        map.put(string, bl);
    }

    public final void click(@NotNull Map<String, ? extends Object> params2) {
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        this.process(new Event.Click(params2));
    }

    public final void view$com_algolia_instantsearch_android_insights(@NotNull Map<String, ? extends Object> params2) {
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        this.process(new Event.View(params2));
    }

    public final void conversion(@NotNull Map<String, ? extends Object> params2) {
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        this.process(new Event.Conversion(params2));
    }

    private final void process(Event event) {
        this.database.append(event);
        this.eventUploader.startOneTimeUpload();
    }

    @NotNull
    public final Database getDatabase$com_algolia_instantsearch_android_insights() {
        return this.database;
    }

    @NotNull
    public final WebService getWebService$com_algolia_instantsearch_android_insights() {
        return this.webService;
    }

    public Insights(@NotNull String indexName, @NotNull EventUploader eventUploader, @NotNull Database database, @NotNull WebService webService) {
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)eventUploader, (String)"eventUploader");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)webService, (String)"webService");
        this.indexName = indexName;
        this.eventUploader = eventUploader;
        this.database = database;
        this.webService = webService;
        this.eventUploader.startPeriodicUpload();
    }

    static {
        Companion = new Companion(null);
        insightsMap = new LinkedHashMap();
    }

    @JvmStatic
    @NotNull
    public static final Insights register(@NotNull Context context, @NotNull String appId, @NotNull String apiKey, @NotNull String indexName, @NotNull Configuration configuration) {
        return Companion.register(context, appId, apiKey, indexName, configuration);
    }

    @JvmStatic
    @NotNull
    public static final Insights shared(@NotNull String indexName) {
        return Companion.shared(indexName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/algolia/instantsearch/insights/Insights$Configuration;", "", "connectTimeoutInMilliseconds", "", "readTimeoutInMilliseconds", "(II)V", "getConnectTimeoutInMilliseconds", "()I", "getReadTimeoutInMilliseconds", "com.algolia.instantsearch-android.insights"})
    public static final class Configuration {
        private final int connectTimeoutInMilliseconds;
        private final int readTimeoutInMilliseconds;

        public final int getConnectTimeoutInMilliseconds() {
            return this.connectTimeoutInMilliseconds;
        }

        public final int getReadTimeoutInMilliseconds() {
            return this.readTimeoutInMilliseconds;
        }

        public Configuration(int connectTimeoutInMilliseconds, int readTimeoutInMilliseconds) {
            this.connectTimeoutInMilliseconds = connectTimeoutInMilliseconds;
            this.readTimeoutInMilliseconds = readTimeoutInMilliseconds;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0007R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/algolia/instantsearch/insights/Insights$Companion;", "", "()V", "insightsMap", "", "", "Lcom/algolia/instantsearch/insights/Insights;", "getInsightsMap$com_algolia_instantsearch_android_insights", "()Ljava/util/Map;", "register", "context", "Landroid/content/Context;", "appId", "apiKey", "indexName", "configuration", "Lcom/algolia/instantsearch/insights/Insights$Configuration;", "shared", "com.algolia.instantsearch-android.insights"})
    public static final class Companion {
        @NotNull
        public final Map<String, Insights> getInsightsMap$com_algolia_instantsearch_android_insights() {
            return insightsMap;
        }

        @JvmStatic
        @NotNull
        public final Insights register(@NotNull Context context, @NotNull String appId, @NotNull String apiKey, @NotNull String indexName, @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            EventUploaderAndroidJob eventUploader = new EventUploaderAndroidJob(context);
            DatabaseSharedPreferences database = new DatabaseSharedPreferences(context, indexName);
            WebServiceHttp webService = new WebServiceHttp(appId, apiKey, WebServiceHttp.Environment.Prod, configuration.getConnectTimeoutInMilliseconds(), configuration.getReadTimeoutInMilliseconds());
            Insights insights = new Insights(indexName, eventUploader, database, webService);
            Map<String, Insights> map = this.getInsightsMap$com_algolia_instantsearch_android_insights();
            Insights insights2 = insights;
            map.put(indexName, insights2);
            return insights;
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ Insights register$default(Companion companion, Context context, String string, String string2, String string3, Configuration configuration, int n, Object object) {
            if ((n & 0x10) != 0) {
                configuration = new Configuration(5000, 5000);
            }
            return companion.register(context, string, string2, string3, configuration);
        }

        @JvmStatic
        @NotNull
        public final Insights shared(@NotNull String indexName) {
            Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
            Insights insights = this.getInsightsMap$com_algolia_instantsearch_android_insights().get(indexName);
            if (insights == null) {
                throw (Throwable)new InstantSearchInsightsException.IndexNotRegistered();
            }
            return insights;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

