/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.ApacheHttpClientConfiguration;
import com.algolia.search.TimeoutableHostNameResolver;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.http.AlgoliaHttpClient;
import com.algolia.search.http.AlgoliaHttpRequest;
import com.algolia.search.http.AlgoliaHttpResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class ApacheHttpClient
extends AlgoliaHttpClient {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final CloseableHttpClient internal;
    private final ObjectMapper objectMapper;
    private final List<String> queryHosts;
    private final List<String> buildHosts;
    private final int hostDownTimeout;

    public ApacheHttpClient(APIClientConfiguration configuration, ApacheHttpClientConfiguration httpClientConfiguration) {
        this.logger.debug("Create ApacheHttpClient with configuration {}", (Object)configuration);
        List httpHeaders = configuration.getHeaders().entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(configuration.getConnectTimeout()).setSocketTimeout(configuration.getReadTimeout()).setConnectionRequestTimeout(configuration.getConnectTimeout());
        if (httpClientConfiguration.getProxy() != null) {
            requestConfigBuilder = requestConfigBuilder.setProxy(httpClientConfiguration.getProxy());
        }
        if (httpClientConfiguration.getProxyPreferredAuthSchemes() != null) {
            requestConfigBuilder = requestConfigBuilder.setProxyPreferredAuthSchemes(httpClientConfiguration.getProxyPreferredAuthSchemes());
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableAutomaticRetries().setDefaultHeaders(httpHeaders).setDnsResolver((DnsResolver)new TimeoutableHostNameResolver(configuration.getConnectTimeout())).setDefaultRequestConfig(requestConfigBuilder.build()).setMaxConnTotal(configuration.getMaxConnTotal()).setMaxConnPerRoute(configuration.getMaxConnPerRoute());
        if (httpClientConfiguration.getDefaultCredentialsProvider() != null) {
            httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider(httpClientConfiguration.getDefaultCredentialsProvider());
        }
        this.internal = httpClientBuilder.build();
        this.objectMapper = configuration.getObjectMapper();
        this.queryHosts = configuration.getQueryHosts();
        this.buildHosts = configuration.getBuildHosts();
        this.hostDownTimeout = configuration.getHostDownTimeout();
    }

    protected AlgoliaHttpResponse request(@Nonnull AlgoliaHttpRequest request) throws IOException {
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod().name).setUri("https://" + request.getHost() + "/" + String.join((CharSequence)"/", request.getPath()));
        for (Map.Entry entry : request.getParameters().entrySet()) {
            builder = builder.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            builder = builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        builder = request.getContent() != null ? builder.setEntity((HttpEntity)new StringEntity(request.getContent(), ContentType.APPLICATION_JSON)) : builder.setEntity((HttpEntity)new StringEntity("", ContentType.APPLICATION_JSON));
        final CloseableHttpResponse response = this.internal.execute(builder.build());
        return new AlgoliaHttpResponse(){

            public void close() throws IOException {
                response.close();
            }

            public int getStatusCode() {
                return response.getStatusLine().getStatusCode();
            }

            public Reader getBody() throws IOException {
                return new InputStreamReader(response.getEntity().getContent(), UTF8);
            }
        };
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public List<String> getQueryHosts() {
        return this.queryHosts;
    }

    public List<String> getBuildHosts() {
        return this.buildHosts;
    }

    public int getHostDownTimeout() {
        return this.hostDownTimeout;
    }

    public void close() throws AlgoliaException {
        this.logger.debug("Closing ApacheHttpClient");
        try {
            this.internal.close();
        }
        catch (IOException e) {
            this.logger.debug("Couldn't close ApacheHttpClient", (Throwable)e);
            throw new AlgoliaException("Couldn't close ApacheHttpClient", (Exception)e);
        }
    }
}

