/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.TimeoutableHostNameResolver;
import com.algolia.search.http.AlgoliaHttpClient;
import com.algolia.search.http.AlgoliaHttpRequest;
import com.algolia.search.http.AlgoliaHttpResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class ApacheHttpClient
extends AlgoliaHttpClient {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final CloseableHttpClient internal;
    private final ObjectMapper objectMapper;
    private final List<String> queryHosts;
    private final List<String> buildHosts;

    public ApacheHttpClient(APIClientConfiguration configuration) {
        List httpHeaders = configuration.getHeaders().entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(configuration.getConnectTimeout()).setSocketTimeout(configuration.getReadTimeout()).build();
        this.internal = HttpClients.custom().disableAutomaticRetries().setDefaultHeaders(httpHeaders).setDnsResolver((DnsResolver)new TimeoutableHostNameResolver(configuration.getConnectTimeout())).setDefaultRequestConfig(requestConfig).build();
        this.objectMapper = configuration.getObjectMapper();
        this.queryHosts = configuration.getQueryHosts();
        this.buildHosts = configuration.getBuildHosts();
    }

    protected AlgoliaHttpResponse request(@Nonnull AlgoliaHttpRequest request) throws IOException {
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod().name).setUri("https://" + request.getHost() + "/" + String.join((CharSequence)"/", request.getPath()));
        if (request.getContent() != null) {
            builder = builder.setEntity((HttpEntity)new StringEntity(request.getContent(), ContentType.APPLICATION_JSON));
        }
        CloseableHttpResponse response = this.internal.execute(builder.build());
        return new AlgoliaHttpResponse((HttpResponse)response){
            final /* synthetic */ HttpResponse val$response;
            {
                this.val$response = httpResponse;
            }

            public int getStatusCode() {
                return this.val$response.getStatusLine().getStatusCode();
            }

            public Reader getBody() throws IOException {
                return new InputStreamReader(this.val$response.getEntity().getContent(), UTF8);
            }
        };
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public List<String> getQueryHosts() {
        return this.queryHosts;
    }

    public List<String> getBuildHosts() {
        return this.buildHosts;
    }
}

