/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import java.util.List;

public class SynonymQuery {
    private String query;
    private List<SynonymType> types = null;
    private Integer page = null;
    private Integer hitsPerPage = null;

    public SynonymQuery(String query) {
        this.query = query;
    }

    public SynonymQuery() {
        this(null);
    }

    public SynonymQuery setQueryString(String query) {
        this.query = query;
        return this;
    }

    public SynonymQuery setTypes(List<SynonymType> types) {
        this.types = types;
        return this;
    }

    public SynonymQuery setPage(Integer page) {
        this.page = page;
        return this;
    }

    public SynonymQuery setHitsPerPage(Integer hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return this;
    }

    public String getQueryString() {
        return this.query;
    }

    public List<SynonymType> getTypes() {
        return this.types;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getHitsPerPage() {
        return this.hitsPerPage;
    }

    public boolean hasTypes() {
        return this.getTypes() != null && !this.getTypes().isEmpty();
    }

    public static enum SynonymType {
        SYNONYM("synonym"),
        SYNONYM_ONEWAY("oneWaySynonym"),
        PLACEHOLDER("placeholder"),
        ALTCORRECTION_1("altCorrection1"),
        ALTCORRECTION_2("altCorrection2");

        public final String name;

        private SynonymType(String name) {
            this.name = name;
        }
    }
}

