/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class Query {
    protected List<String> attributes;
    protected List<String> attributesToHighlight;
    protected List<String> attributesToSnippet;
    protected Integer minWordSizeForApprox1;
    protected Integer minWordSizeForApprox2;
    protected Boolean getRankingInfo;
    protected Boolean ignorePlural;
    protected Integer distinct;
    protected Boolean advancedSyntax;
    protected Integer page;
    protected Integer hitsPerPage;
    protected String restrictSearchableAttributes;
    protected String tags;
    protected String highlightPreTag;
    protected String highlightPostTag;
    protected Integer minProximity;
    protected String numerics;
    protected String insideBoundingBox;
    protected String aroundLatLong;
    protected Boolean aroundLatLongViaIP;
    protected String query;
    protected QueryType queryType;
    protected String optionalWords;
    protected String facets;
    protected String facetFilters;
    protected Integer maxNumberOfFacets;
    protected Boolean analytics;
    protected Boolean synonyms;
    protected Boolean replaceSynonyms;
    protected Boolean allowTyposOnNumericTokens;
    protected RemoveWordsType removeWordsIfNoResult;
    protected TypoTolerance typoTolerance;
    protected String analyticsTags;

    public Query(String query) {
        this.minWordSizeForApprox1 = null;
        this.minWordSizeForApprox2 = null;
        this.getRankingInfo = null;
        this.ignorePlural = null;
        this.distinct = null;
        this.page = null;
        this.minProximity = null;
        this.hitsPerPage = null;
        this.query = query;
        this.queryType = QueryType.PREFIX_NOTSET;
        this.maxNumberOfFacets = null;
        this.advancedSyntax = null;
        this.allowTyposOnNumericTokens = null;
        this.replaceSynonyms = null;
        this.synonyms = null;
        this.analytics = null;
        this.analyticsTags = null;
        this.typoTolerance = TypoTolerance.TYPO_NOTSET;
        this.removeWordsIfNoResult = RemoveWordsType.REMOVE_NOTSET;
    }

    public Query() {
        this((String)null);
    }

    public Query(Query other) {
        if (other.attributesToHighlight != null) {
            this.attributesToHighlight = new ArrayList<String>(other.attributesToHighlight);
        }
        if (other.attributes != null) {
            this.attributes = new ArrayList<String>(other.attributes);
        }
        if (other.attributesToSnippet != null) {
            this.attributesToSnippet = new ArrayList<String>(other.attributesToSnippet);
        }
        this.minWordSizeForApprox1 = other.minWordSizeForApprox1;
        this.minWordSizeForApprox2 = other.minWordSizeForApprox2;
        this.getRankingInfo = other.getRankingInfo;
        this.ignorePlural = other.ignorePlural;
        this.minProximity = other.minProximity;
        this.highlightPreTag = other.highlightPreTag;
        this.highlightPostTag = other.highlightPostTag;
        this.distinct = other.distinct;
        this.advancedSyntax = other.advancedSyntax;
        this.page = other.page;
        this.hitsPerPage = other.hitsPerPage;
        this.restrictSearchableAttributes = other.restrictSearchableAttributes;
        this.tags = other.tags;
        this.numerics = other.numerics;
        this.insideBoundingBox = other.insideBoundingBox;
        this.aroundLatLong = other.aroundLatLong;
        this.aroundLatLongViaIP = other.aroundLatLongViaIP;
        this.query = other.query;
        this.queryType = other.queryType;
        this.optionalWords = other.optionalWords;
        this.facets = other.facets;
        this.facetFilters = other.facetFilters;
        this.maxNumberOfFacets = other.maxNumberOfFacets;
        this.analytics = other.analytics;
        this.analyticsTags = other.analyticsTags;
        this.synonyms = other.synonyms;
        this.replaceSynonyms = other.replaceSynonyms;
        this.typoTolerance = other.typoTolerance;
        this.allowTyposOnNumericTokens = other.allowTyposOnNumericTokens;
        this.removeWordsIfNoResult = other.removeWordsIfNoResult;
    }

    public Query removeWordsIfNoResult(RemoveWordsType type) {
        this.removeWordsIfNoResult = type;
        return this;
    }

    public Query restrictSearchableAttributes(String attributes) {
        this.restrictSearchableAttributes = attributes;
        return this;
    }

    public Query setQueryType(QueryType type) {
        this.queryType = type;
        return this;
    }

    public Query setQueryString(String query) {
        this.query = query;
        return this;
    }

    public Query setAttributesToRetrieve(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Query setAttributesToHighlight(List<String> attributes) {
        this.attributesToHighlight = attributes;
        return this;
    }

    public Query setAttributesToSnippet(List<String> attributes) {
        this.attributesToSnippet = attributes;
        return this;
    }

    public Query enableDistinct(boolean distinct) {
        this.distinct = distinct ? 1 : 0;
        return this;
    }

    public Query enableDistinct(int nbHitsToKeep) {
        this.distinct = nbHitsToKeep;
        return this;
    }

    public Query enableAnalytics(boolean enabled) {
        this.analytics = enabled;
        return this;
    }

    public Query setAnalyticsTags(String analyticsTags) {
        this.analyticsTags = analyticsTags;
        return this;
    }

    public Query enableSynonyms(boolean enabled) {
        this.synonyms = enabled;
        return this;
    }

    public Query enableReplaceSynonymsInHighlight(boolean enabled) {
        this.replaceSynonyms = enabled;
        return this;
    }

    public Query enableTypoTolerance(boolean enabled) {
        this.typoTolerance = enabled ? TypoTolerance.TYPO_TRUE : TypoTolerance.TYPO_FALSE;
        return this;
    }

    public Query setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return this;
    }

    public Query setMinWordSizeToAllowOneTypo(int nbChars) {
        this.minWordSizeForApprox1 = nbChars;
        return this;
    }

    public Query setMinProximity(int value) {
        this.minProximity = value;
        return this;
    }

    public Query setHighlightingTags(String preTag, String postTag) {
        this.highlightPreTag = preTag;
        this.highlightPostTag = postTag;
        return this;
    }

    public Query setMinWordSizeToAllowTwoTypos(int nbChars) {
        this.minWordSizeForApprox2 = nbChars;
        return this;
    }

    public Query enableTyposOnNumericTokens(boolean enabled) {
        this.allowTyposOnNumericTokens = enabled;
        return this;
    }

    public Query getRankingInfo(boolean enabled) {
        this.getRankingInfo = enabled;
        return this;
    }

    public Query ignorePlural(boolean enabled) {
        this.ignorePlural = enabled;
        return this;
    }

    public Query setPage(int page) {
        this.page = page;
        return this;
    }

    public Query setHitsPerPage(int nbHitsPerPage) {
        this.hitsPerPage = nbHitsPerPage;
        return this;
    }

    @Deprecated
    public Query setNbHitsPerPage(int nbHitsPerPage) {
        return this.setHitsPerPage(nbHitsPerPage);
    }

    public Query aroundLatitudeLongitude(float latitude, float longitude, int radius) {
        this.aroundLatLong = "aroundLatLng=" + latitude + "," + longitude + "&aroundRadius=" + radius;
        return this;
    }

    public Query aroundLatitudeLongitude(float latitude, float longitude, int radius, int precision) {
        this.aroundLatLong = "aroundLatLng=" + latitude + "," + longitude + "&aroundRadius=" + radius + "&aroundPrecision=" + precision;
        return this;
    }

    public Query aroundLatitudeLongitudeViaIP(boolean enabled, int radius) {
        this.aroundLatLong = "aroundRadius=" + radius;
        this.aroundLatLongViaIP = enabled;
        return this;
    }

    public Query aroundLatitudeLongitudeViaIP(boolean enabled, int radius, int precision) {
        this.aroundLatLong = "aroundRadius=" + radius + "&aroundPrecision=" + precision;
        this.aroundLatLongViaIP = enabled;
        return this;
    }

    public Query insideBoundingBox(float latitudeP1, float longitudeP1, float latitudeP2, float longitudeP2) {
        this.insideBoundingBox = "insideBoundingBox=" + latitudeP1 + "," + longitudeP1 + "," + latitudeP2 + "," + longitudeP2;
        return this;
    }

    public Query setOptionalWords(String words) {
        this.optionalWords = words;
        return this;
    }

    public Query setOptionalWords(List<String> words) {
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            builder.append(word);
            builder.append(",");
        }
        this.optionalWords = builder.toString();
        return this;
    }

    public Query setFacetFilters(List<String> facets) {
        JSONArray obj = new JSONArray();
        for (String facet : facets) {
            obj.put((Object)facet);
        }
        this.facetFilters = obj.toString();
        return this;
    }

    public Query setFacetFilters(String facetFilters) {
        this.facetFilters = facetFilters;
        return this;
    }

    public Query setFacets(List<String> facets) {
        JSONArray obj = new JSONArray();
        for (String facet : facets) {
            obj.put((Object)facet);
        }
        this.facets = obj.toString();
        return this;
    }

    public Query setMaxNumberOfFacets(int n) {
        this.maxNumberOfFacets = n;
        return this;
    }

    public Query setTagFilters(String tags) {
        this.tags = tags;
        return this;
    }

    public Query setNumericFilters(String numerics) {
        this.numerics = numerics;
        return this;
    }

    public Query setNumericFilters(List<String> numerics) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String n : numerics) {
            if (!first) {
                builder.append(",");
            }
            builder.append(n);
            first = false;
        }
        this.numerics = builder.toString();
        return this;
    }

    public Query enableAvancedSyntax(boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return this;
    }

    protected String getQueryString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            boolean first;
            if (this.attributes != null) {
                stringBuilder.append("attributes=");
                first = true;
                for (String attr : this.attributes) {
                    if (!first) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(URLEncoder.encode(attr, "UTF-8"));
                    first = false;
                }
            }
            if (this.attributesToHighlight != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("attributesToHighlight=");
                first = true;
                for (String attr : this.attributesToHighlight) {
                    if (!first) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(URLEncoder.encode(attr, "UTF-8"));
                    first = false;
                }
            }
            if (this.attributesToSnippet != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("attributesToSnippet=");
                first = true;
                for (String attr : this.attributesToSnippet) {
                    if (!first) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(URLEncoder.encode(attr, "UTF-8"));
                    first = false;
                }
            }
            if (this.typoTolerance != TypoTolerance.TYPO_NOTSET) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("typoTolerance=");
                switch (this.typoTolerance) {
                    case TYPO_FALSE: {
                        stringBuilder.append("false");
                        break;
                    }
                    case TYPO_MIN: {
                        stringBuilder.append("min");
                        break;
                    }
                    case TYPO_STRICT: {
                        stringBuilder.append("strict");
                        break;
                    }
                    case TYPO_TRUE: {
                        stringBuilder.append("true");
                        break;
                    }
                    case TYPO_NOTSET: {
                        throw new IllegalStateException("code not reachable");
                    }
                }
            }
            if (this.allowTyposOnNumericTokens != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("allowTyposOnNumericTokens=").append(this.allowTyposOnNumericTokens != false ? (char)'1' : '0');
            }
            if (this.minWordSizeForApprox1 != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("minWordSizefor1Typo=");
                stringBuilder.append(this.minWordSizeForApprox1);
            }
            if (this.minWordSizeForApprox2 != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("minWordSizefor2Typos=");
                stringBuilder.append(this.minWordSizeForApprox2);
            }
            switch (this.removeWordsIfNoResult) {
                case REMOVE_LAST_WORDS: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=LastWords");
                    break;
                }
                case REMOVE_FIRST_WORDS: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=FirstWords");
                    break;
                }
                case REMOVE_ALLOPTIONAL: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=allOptional");
                    break;
                }
                case REMOVE_NONE: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=none");
                    break;
                }
            }
            if (this.getRankingInfo != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("getRankingInfo=").append(this.getRankingInfo != false ? (char)'1' : '0');
            }
            if (this.ignorePlural != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("ignorePlural=").append(this.ignorePlural != false ? (char)'1' : '0');
            }
            if (this.analytics != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("analytics=").append(this.analytics != false ? (char)'1' : '0');
            }
            if (this.analyticsTags != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("analyticsTags=" + this.analyticsTags);
            }
            if (this.synonyms != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("synonyms=").append(this.synonyms != false ? (char)'1' : '0');
            }
            if (this.replaceSynonyms != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("replaceSynonymsInHighlight=").append(this.replaceSynonyms != false ? (char)'1' : '0');
            }
            if (this.distinct != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("distinct=");
                stringBuilder.append(this.distinct);
            }
            if (this.advancedSyntax != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("advancedSyntax=").append(this.advancedSyntax != false ? (char)'1' : '0');
            }
            if (this.page != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("page=");
                stringBuilder.append(this.page);
            }
            if (this.minProximity != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("minProximity=");
                stringBuilder.append(this.minProximity);
            }
            if (this.highlightPreTag != null && this.highlightPostTag != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("highlightPreTag=");
                stringBuilder.append(this.highlightPreTag);
                stringBuilder.append("&highlightPostTag=");
                stringBuilder.append(this.highlightPostTag);
            }
            if (this.hitsPerPage != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("hitsPerPage=");
                stringBuilder.append(this.hitsPerPage);
            }
            if (this.tags != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("tagFilters=");
                stringBuilder.append(URLEncoder.encode(this.tags, "UTF-8"));
            }
            if (this.numerics != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("numericFilters=");
                stringBuilder.append(URLEncoder.encode(this.numerics, "UTF-8"));
            }
            if (this.insideBoundingBox != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(this.insideBoundingBox);
            } else if (this.aroundLatLong != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(this.aroundLatLong);
            }
            if (this.aroundLatLongViaIP != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("aroundLatLngViaIP=").append(this.aroundLatLongViaIP != false ? (char)'1' : '0');
            }
            if (this.query != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("query=");
                stringBuilder.append(URLEncoder.encode(this.query, "UTF-8"));
            }
            if (this.facets != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("facets=");
                stringBuilder.append(URLEncoder.encode(this.facets, "UTF-8"));
            }
            if (this.facetFilters != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("facetFilters=");
                stringBuilder.append(URLEncoder.encode(this.facetFilters, "UTF-8"));
            }
            if (this.maxNumberOfFacets != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("maxNumberOfFacets=");
                stringBuilder.append(this.maxNumberOfFacets);
            }
            if (this.optionalWords != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("optionalWords=");
                stringBuilder.append(URLEncoder.encode(this.optionalWords, "UTF-8"));
            }
            if (this.restrictSearchableAttributes != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("restrictSearchableAttributes=");
                stringBuilder.append(URLEncoder.encode(this.restrictSearchableAttributes, "UTF-8"));
            }
            switch (this.queryType) {
                case PREFIX_ALL: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("queryType=prefixAll");
                    break;
                }
                case PREFIX_LAST: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("queryType=prefixLast");
                    break;
                }
                case PREFIX_NONE: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("queryType=prefixNone");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributesToHighlight() {
        return this.attributesToHighlight;
    }

    public List<String> getAttributesToSnippet() {
        return this.attributesToSnippet;
    }

    public Integer getMinWordSizeForApprox1() {
        return this.minWordSizeForApprox1;
    }

    public Integer getMinWordSizeForApprox2() {
        return this.minWordSizeForApprox2;
    }

    public Boolean isGetRankingInfo() {
        return this.getRankingInfo;
    }

    public Boolean isIgnorePlural() {
        return this.ignorePlural;
    }

    public Boolean isDistinct() {
        return this.distinct > 0;
    }

    public Integer getDistinct() {
        return this.distinct;
    }

    public Boolean isAdvancedSyntax() {
        return this.advancedSyntax;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getHitsPerPage() {
        return this.hitsPerPage;
    }

    public String getRestrictSearchableAttributes() {
        return this.restrictSearchableAttributes;
    }

    public String getTags() {
        return this.tags;
    }

    public String getNumerics() {
        return this.numerics;
    }

    public String getInsideBoundingBox() {
        return this.insideBoundingBox;
    }

    public String getAroundLatLong() {
        return this.aroundLatLong;
    }

    public Boolean isAroundLatLongViaIP() {
        return this.aroundLatLongViaIP;
    }

    public String getQuery() {
        return this.query;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public String getOptionalWords() {
        return this.optionalWords;
    }

    public String getFacets() {
        return this.facets;
    }

    public String getFacetFilters() {
        return this.facetFilters;
    }

    public Integer getMaxNumberOfFacets() {
        return this.maxNumberOfFacets;
    }

    public Boolean isAnalytics() {
        return this.analytics;
    }

    public String getAnalyticsTags() {
        return this.analyticsTags;
    }

    public Boolean isSynonyms() {
        return this.synonyms;
    }

    public Boolean isReplaceSynonyms() {
        return this.replaceSynonyms;
    }

    public Boolean isAllowTyposOnNumericTokens() {
        return this.allowTyposOnNumericTokens;
    }

    public RemoveWordsType getRemoveWordsIfNoResult() {
        return this.removeWordsIfNoResult;
    }

    public TypoTolerance getTypoTolerance() {
        return this.typoTolerance;
    }

    public static enum TypoTolerance {
        TYPO_TRUE,
        TYPO_FALSE,
        TYPO_MIN,
        TYPO_STRICT,
        TYPO_NOTSET;

    }

    public static enum RemoveWordsType {
        REMOVE_LAST_WORDS,
        REMOVE_FIRST_WORDS,
        REMOVE_NONE,
        REMOVE_ALLOPTIONAL,
        REMOVE_NOTSET;

    }

    public static enum QueryType {
        PREFIX_ALL,
        PREFIX_LAST,
        PREFIX_NONE,
        PREFIX_NOTSET;

    }
}

