/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.settings;

import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.models.settings.RemoveStopWords;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;

class RemoveStopWordsDeserializer
extends JsonDeserializer<RemoveStopWords> {
    RemoveStopWordsDeserializer() {
    }

    public RemoveStopWords deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = p.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_FALSE) || currentToken.equals((Object)JsonToken.VALUE_TRUE)) {
            return RemoveStopWords.of(p.getBooleanValue());
        }
        if (currentToken == JsonToken.START_ARRAY) {
            ArrayList<String> removeStopWords = new ArrayList<String>();
            while (p.nextToken() != JsonToken.END_ARRAY) {
                removeStopWords.add(p.getValueAsString());
            }
            return RemoveStopWords.of(removeStopWords);
        }
        throw new AlgoliaRuntimeException("Unsupported deserialization for RemoveStopWords");
    }
}

