/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.settings;

import com.algolia.search.models.settings.Distinct;
import com.algolia.search.models.settings.IgnorePlurals;
import com.algolia.search.models.settings.RemoveStopWords;
import com.algolia.search.models.settings.TypoTolerance;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IndexSettings
implements Serializable {
    private String attributeForDistinct;
    private Distinct distinct;
    private Boolean replaceSynonymsInHighlight;
    private Integer minProximity;
    private Boolean attributeCriteriaComputedByMinProximity;
    private List<String> responseFields;
    private Integer maxFacetHits;
    private String keepDiacriticsOnCharacters;
    private List<String> queryLanguages;
    private List<String> indexLanguages;
    private List<String> searchableAttributes;
    private List<String> attributesForFaceting;
    private List<String> unretrievableAttributes;
    private List<String> attributesToRetrieve;
    private List<String> camelCaseAttributes;
    private Map<String, List<String>> decompoundedAttributes;
    private String primary;
    private Map<String, Object> userData;
    private Long maxValuesPerFacet;
    private String sortFacetValuesBy;
    private List<String> attributesToHighlight;
    private List<String> attributesToSnippet;
    private String highlightPreTag;
    private String highlightPostTag;
    private String snippetEllipsisText;
    private Boolean restrictHighlightAndSnippetArrays;
    private Long hitsPerPage;
    private Long paginationLimitedTo;
    private List<String> numericAttributesForFiltering;
    private Boolean allowCompressionOfIntegerArray;
    private Boolean enableRules;
    private String queryType;
    private String removeWordsIfNoResults;
    private Boolean advancedSyntax;
    private List<String> advancedSyntaxFeatures;
    private List<String> optionalWords;
    private RemoveStopWords removeStopWords;
    private List<String> disablePrefixOnAttributes;
    private List<String> disableExactOnAttributes;
    private String exactOnSingleWordQuery;
    private List<String> alternativesAsExact;
    private List<String> ranking;
    private List<String> customRanking;
    private List<String> replicas;
    private Integer minWordSizefor1Typo;
    private Integer minWordSizefor2Typos;
    private TypoTolerance typoTolerance;
    private Boolean allowTyposOnNumericTokens;
    private IgnorePlurals ignorePlurals;
    private List<String> disableTypoToleranceOnAttributes;
    private List<String> disableTypoToleranceOnWords;
    private String separatorsToIndex;
    private Map<String, Object> customSettings = new HashMap<String, Object>();

    public List<String> getAttributesForFaceting() {
        return this.attributesForFaceting;
    }

    public IndexSettings setAttributesForFaceting(List<String> attributesForFaceting) {
        this.attributesForFaceting = attributesForFaceting;
        return this;
    }

    public String getAttributeForDistinct() {
        return this.attributeForDistinct;
    }

    public IndexSettings setAttributeForDistinct(String attributeForDistinct) {
        this.attributeForDistinct = attributeForDistinct;
        return this;
    }

    public List<String> getRanking() {
        return this.ranking;
    }

    public IndexSettings setRanking(List<String> ranking) {
        this.ranking = ranking;
        return this;
    }

    public List<String> getCustomRanking() {
        return this.customRanking;
    }

    public IndexSettings setCustomRanking(List<String> customRanking) {
        this.customRanking = customRanking;
        return this;
    }

    public String getSeparatorsToIndex() {
        return this.separatorsToIndex;
    }

    public IndexSettings setSeparatorsToIndex(String separatorsToIndex) {
        this.separatorsToIndex = separatorsToIndex;
        return this;
    }

    public List<String> getUnretrievableAttributes() {
        return this.unretrievableAttributes;
    }

    public IndexSettings setUnretrievableAttributes(List<String> unretrievableAttributes) {
        this.unretrievableAttributes = unretrievableAttributes;
        return this;
    }

    public Boolean getAllowCompressionOfIntegerArray() {
        return this.allowCompressionOfIntegerArray;
    }

    public IndexSettings setAllowCompressionOfIntegerArray(Boolean allowCompressionOfIntegerArray) {
        this.allowCompressionOfIntegerArray = allowCompressionOfIntegerArray;
        return this;
    }

    public List<String> getDisableTypoToleranceOnWords() {
        return this.disableTypoToleranceOnWords;
    }

    public IndexSettings setDisableTypoToleranceOnWords(List<String> disableTypoToleranceOnWords) {
        this.disableTypoToleranceOnWords = disableTypoToleranceOnWords;
        return this;
    }

    public List<String> getDisableTypoToleranceOnAttributes() {
        return this.disableTypoToleranceOnAttributes;
    }

    public IndexSettings setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
        this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
        return this;
    }

    public Integer getMinWordSizefor1Typo() {
        return this.minWordSizefor1Typo;
    }

    public IndexSettings setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
        this.minWordSizefor1Typo = minWordSizefor1Typo;
        return this;
    }

    public Integer getMinWordSizefor2Typos() {
        return this.minWordSizefor2Typos;
    }

    public IndexSettings setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
        this.minWordSizefor2Typos = minWordSizefor2Typos;
        return this;
    }

    public Long getHitsPerPage() {
        return this.hitsPerPage;
    }

    public IndexSettings setHitsPerPage(Integer hitsPerPage) {
        return this.setHitsPerPage(hitsPerPage.longValue());
    }

    @JsonSetter
    public IndexSettings setHitsPerPage(Long hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return this;
    }

    public List<String> getAttributesToRetrieve() {
        return this.attributesToRetrieve;
    }

    public IndexSettings setAttributesToRetrieve(List<String> attributesToRetrieve) {
        this.attributesToRetrieve = attributesToRetrieve;
        return this;
    }

    public List<String> getCamelCaseAttributes() {
        return this.camelCaseAttributes;
    }

    public IndexSettings setCamelCaseAttributes(List<String> camelCaseAttributes) {
        this.camelCaseAttributes = camelCaseAttributes;
        return this;
    }

    public Map<String, List<String>> getDecompoundedAttributes() {
        return this.decompoundedAttributes;
    }

    public IndexSettings setDecompoundedAttributes(Map<String, List<String>> decompoundedAttributes) {
        this.decompoundedAttributes = decompoundedAttributes;
        return this;
    }

    public String getPrimary() {
        return this.primary;
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public IndexSettings setUserData(Map<String, Object> userData) {
        this.userData = userData;
        return this;
    }

    public List<String> getAttributesToHighlight() {
        return this.attributesToHighlight;
    }

    public IndexSettings setAttributesToHighlight(List<String> attributesToHighlight) {
        this.attributesToHighlight = attributesToHighlight;
        return this;
    }

    public List<String> getAttributesToSnippet() {
        return this.attributesToSnippet;
    }

    public IndexSettings setAttributesToSnippet(List<String> attributesToSnippet) {
        this.attributesToSnippet = attributesToSnippet;
        return this;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public IndexSettings setQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    public Integer getMinProximity() {
        return this.minProximity;
    }

    public IndexSettings setMinProximity(Integer minProximity) {
        this.minProximity = minProximity;
        return this;
    }

    public Boolean getAttributeCriteriaComputedByMinProximity() {
        return this.attributeCriteriaComputedByMinProximity;
    }

    public IndexSettings setAttributeCriteriaComputedByMinProximity(Boolean attributeCriteriaComputedByMinProximity) {
        this.attributeCriteriaComputedByMinProximity = attributeCriteriaComputedByMinProximity;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public IndexSettings setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public IndexSettings setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public List<String> getOptionalWords() {
        return this.optionalWords;
    }

    public IndexSettings setOptionalWords(List<String> optionalWords) {
        this.optionalWords = optionalWords;
        return this;
    }

    public Boolean getAllowTyposOnNumericTokens() {
        return this.allowTyposOnNumericTokens;
    }

    public IndexSettings setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
        this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
        return this;
    }

    public IgnorePlurals getIgnorePlurals() {
        return this.ignorePlurals;
    }

    @JsonIgnore
    public IndexSettings setIgnorePlurals(List<String> ignorePlurals) {
        return this.setIgnorePlurals(IgnorePlurals.of(ignorePlurals));
    }

    @JsonProperty
    public IndexSettings setIgnorePlurals(IgnorePlurals ignorePlurals) {
        this.ignorePlurals = ignorePlurals;
        return this;
    }

    @JsonIgnore
    public IndexSettings setIgnorePlurals(Boolean ignorePlurals) {
        return this.setIgnorePlurals(IgnorePlurals.of(ignorePlurals));
    }

    public Boolean getAdvancedSyntax() {
        return this.advancedSyntax;
    }

    public IndexSettings setAdvancedSyntax(Boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return this;
    }

    public List<String> getAdvancedSyntaxFeatures() {
        return this.advancedSyntaxFeatures;
    }

    public IndexSettings setAdvancedSyntaxFeatures(List<String> advancedSyntaxFeatures) {
        this.advancedSyntaxFeatures = advancedSyntaxFeatures;
        return this;
    }

    public Boolean getReplaceSynonymsInHighlight() {
        return this.replaceSynonymsInHighlight;
    }

    public IndexSettings setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
        this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
        return this;
    }

    public Long getMaxValuesPerFacet() {
        return this.maxValuesPerFacet;
    }

    public IndexSettings setMaxValuesPerFacet(Integer maxValuesPerFacet) {
        return this.setMaxValuesPerFacet(maxValuesPerFacet.longValue());
    }

    @JsonSetter
    public IndexSettings setMaxValuesPerFacet(Long maxValuesPerFacet) {
        this.maxValuesPerFacet = maxValuesPerFacet;
        return this;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    @JsonIgnore
    public IndexSettings setDistinct(Boolean distinct) {
        return this.setDistinct(Distinct.of(distinct));
    }

    @JsonProperty
    public IndexSettings setDistinct(Distinct distinct) {
        this.distinct = distinct;
        return this;
    }

    @JsonIgnore
    public IndexSettings setDistinct(Integer distinct) {
        return this.setDistinct(Distinct.of(distinct));
    }

    public TypoTolerance getTypoTolerance() {
        return this.typoTolerance;
    }

    public IndexSettings setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return this;
    }

    public RemoveStopWords getRemoveStopWords() {
        return this.removeStopWords;
    }

    @JsonIgnore
    public IndexSettings setRemoveStopWords(List<String> removeStopWords) {
        return this.setRemoveStopWords(RemoveStopWords.of(removeStopWords));
    }

    @JsonProperty
    public IndexSettings setRemoveStopWords(RemoveStopWords removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this;
    }

    @JsonIgnore
    public IndexSettings setRemoveStopWords(Boolean removeStopWords) {
        return this.setRemoveStopWords(RemoveStopWords.of(removeStopWords));
    }

    public String getSnippetEllipsisText() {
        return this.snippetEllipsisText;
    }

    public IndexSettings setSnippetEllipsisText(String snippetEllipsisText) {
        this.snippetEllipsisText = snippetEllipsisText;
        return this;
    }

    public String getRemoveWordsIfNoResults() {
        return this.removeWordsIfNoResults;
    }

    public IndexSettings setRemoveWordsIfNoResults(String removeWordsIfNoResults) {
        this.removeWordsIfNoResults = removeWordsIfNoResults;
        return this;
    }

    public List<String> getReplicas() {
        return this.replicas;
    }

    public IndexSettings setReplicas(List<String> replicas) {
        this.replicas = replicas;
        return this;
    }

    @JsonSetter(value="slaves")
    public IndexSettings setSlaves(List<String> slaves) {
        if (this.replicas == null && slaves != null) {
            this.setReplicas(slaves);
        }
        return this;
    }

    public List<String> getSearchableAttributes() {
        return this.searchableAttributes;
    }

    public IndexSettings setSearchableAttributes(List<String> searchableAttributes) {
        this.searchableAttributes = searchableAttributes;
        return this;
    }

    @JsonSetter(value="attributesToIndex")
    public IndexSettings setAttributesToIndex(List<String> attributesToIndex) {
        if (this.searchableAttributes == null && attributesToIndex != null) {
            this.setSearchableAttributes(attributesToIndex);
        }
        return this;
    }

    public List<String> getResponseFields() {
        return this.responseFields;
    }

    public IndexSettings setResponseFields(List<String> responseFields) {
        this.responseFields = responseFields;
        return this;
    }

    public Integer getMaxFacetHits() {
        return this.maxFacetHits;
    }

    public IndexSettings setMaxFacetHits(Integer maxFacetHits) {
        this.maxFacetHits = maxFacetHits;
        return this;
    }

    public Boolean getRestrictHighlightAndSnippetArrays() {
        return this.restrictHighlightAndSnippetArrays;
    }

    public IndexSettings setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
        this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
        return this;
    }

    public Long getPaginationLimitedTo() {
        return this.paginationLimitedTo;
    }

    public IndexSettings setPaginationLimitedTo(Integer paginationLimitedTo) {
        return this.setPaginationLimitedTo(paginationLimitedTo.longValue());
    }

    @JsonSetter
    public IndexSettings setPaginationLimitedTo(Long paginationLimitedTo) {
        this.paginationLimitedTo = paginationLimitedTo;
        return this;
    }

    public List<String> getNumericAttributesForFiltering() {
        return this.numericAttributesForFiltering;
    }

    public IndexSettings setNumericAttributesForFiltering(List<String> numericAttributesForFiltering) {
        this.numericAttributesForFiltering = numericAttributesForFiltering;
        return this;
    }

    @JsonSetter(value="numericAttributesToIndex")
    public IndexSettings setNumericAttributesToIndex(List<String> numericAttributesToIndex) {
        if (this.numericAttributesForFiltering == null && numericAttributesToIndex != null) {
            this.setNumericAttributesForFiltering(numericAttributesToIndex);
        }
        return this;
    }

    public List<String> getDisablePrefixOnAttributes() {
        return this.disablePrefixOnAttributes;
    }

    public IndexSettings setDisablePrefixOnAttributes(List<String> disablePrefixOnAttributes) {
        this.disablePrefixOnAttributes = disablePrefixOnAttributes;
        return this;
    }

    public List<String> getDisableExactOnAttributes() {
        return this.disableExactOnAttributes;
    }

    public IndexSettings setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
        this.disableExactOnAttributes = disableExactOnAttributes;
        return this;
    }

    public String getExactOnSingleWordQuery() {
        return this.exactOnSingleWordQuery;
    }

    public IndexSettings setExactOnSingleWordQuery(String exactOnSingleWordQuery) {
        this.exactOnSingleWordQuery = exactOnSingleWordQuery;
        return this;
    }

    public List<String> getAlternativesAsExact() {
        return this.alternativesAsExact;
    }

    public IndexSettings setAlternativesAsExact(List<String> alternativesAsExact) {
        this.alternativesAsExact = alternativesAsExact;
        return this;
    }

    public Boolean getEnableRules() {
        return this.enableRules;
    }

    public IndexSettings setEnableRules(Boolean enableRules) {
        this.enableRules = enableRules;
        return this;
    }

    public String getSortFacetValuesBy() {
        return this.sortFacetValuesBy;
    }

    public IndexSettings setSortFacetValuesBy(String sortFacetValuesBy) {
        this.sortFacetValuesBy = sortFacetValuesBy;
        return this;
    }

    public String getKeepDiacriticsOnCharacters() {
        return this.keepDiacriticsOnCharacters;
    }

    public IndexSettings setKeepDiacriticsOnCharacters(String keepDiacriticsOnCharacters) {
        this.keepDiacriticsOnCharacters = keepDiacriticsOnCharacters;
        return this;
    }

    public List<String> getQueryLanguages() {
        return this.queryLanguages;
    }

    public IndexSettings setQueryLanguages(List<String> queryLanguages) {
        this.queryLanguages = queryLanguages;
        return this;
    }

    public List<String> getIndexLanguages() {
        return this.indexLanguages;
    }

    public IndexSettings setIndexLanguages(List<String> indexLanguages) {
        this.indexLanguages = indexLanguages;
        return this;
    }

    @JsonAnySetter
    public IndexSettings setCustomSetting(String key, Object value) {
        this.customSettings.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    @JsonAnySetter
    public IndexSettings setCustomSettings(Map<String, Object> customSettings) {
        this.customSettings = customSettings;
        return this;
    }

    public String toString() {
        return "IndexSettings{attributeForDistinct='" + this.attributeForDistinct + '\'' + ", distinct=" + this.distinct + ", replaceSynonymsInHighlight=" + this.replaceSynonymsInHighlight + ", minProximity=" + this.minProximity + ", responseFields=" + this.responseFields + ", maxFacetHits=" + this.maxFacetHits + ", searchableAttributes=" + this.searchableAttributes + ", attributesForFaceting=" + this.attributesForFaceting + ", unretrievableAttributes=" + this.unretrievableAttributes + ", attributesToRetrieve=" + this.attributesToRetrieve + ", camelCaseAttributes=" + this.camelCaseAttributes + ", decompoundedAttributes=" + this.decompoundedAttributes + ", maxValuesPerFacet=" + this.maxValuesPerFacet + ", sortFacetValuesBy=" + this.sortFacetValuesBy + ", attributesToHighlight=" + this.attributesToHighlight + ", attributesToSnippet=" + this.attributesToSnippet + ", highlightPreTag='" + this.highlightPreTag + '\'' + ", highlightPostTag='" + this.highlightPostTag + '\'' + ", snippetEllipsisText='" + this.snippetEllipsisText + '\'' + ", restrictHighlightAndSnippetArrays=" + this.restrictHighlightAndSnippetArrays + ", hitsPerPage=" + this.hitsPerPage + ", paginationLimitedTo=" + this.paginationLimitedTo + ", numericAttributesForFiltering=" + this.numericAttributesForFiltering + ", allowCompressionOfIntegerArray=" + this.allowCompressionOfIntegerArray + ", enableRules=" + this.enableRules + ", queryType='" + this.queryType + '\'' + ", removeWordsIfNoResults='" + this.removeWordsIfNoResults + '\'' + ", advancedSyntax=" + this.advancedSyntax + ", advancedSyntaxFeatures=" + this.advancedSyntaxFeatures + ", optionalWords=" + this.optionalWords + ", removeStopWords=" + this.removeStopWords + ", disablePrefixOnAttributes=" + this.disablePrefixOnAttributes + ", disableExactOnAttributes=" + this.disableExactOnAttributes + ", exactOnSingleWordQuery='" + this.exactOnSingleWordQuery + '\'' + ", alternativesAsExact=" + this.alternativesAsExact + ", ranking=" + this.ranking + ", customRanking=" + this.customRanking + ", replicas=" + this.replicas + ", minWordSizefor1Typo=" + this.minWordSizefor1Typo + ", minWordSizefor2Typos=" + this.minWordSizefor2Typos + ", typoTolerance=" + this.typoTolerance + ", allowTyposOnNumericTokens=" + this.allowTyposOnNumericTokens + ", ignorePlurals=" + this.ignorePlurals + ", disableTypoToleranceOnAttributes=" + this.disableTypoToleranceOnAttributes + ", disableTypoToleranceOnWords=" + this.disableTypoToleranceOnWords + ", separatorsToIndex='" + this.separatorsToIndex + '\'' + ", keepDiacriticsOnCharacters='" + this.keepDiacriticsOnCharacters + '\'' + ", queryLanguages=" + this.queryLanguages + '}';
    }
}

