/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchIndexBase;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.settings.IndexSettings;
import com.algolia.search.models.settings.SetSettingsResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public interface SearchIndexSettings<T>
extends SearchIndexBase<T> {
    default public SetSettingsResponse setSettings(@Nonnull IndexSettings settings) {
        return LaunderThrowable.await(this.setSettingsAsync(settings));
    }

    default public SetSettingsResponse setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.setSettingsAsync(settings, forwardToReplicas));
    }

    default public SetSettingsResponse setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.setSettingsAsync(settings, forwardToReplicas, requestOptions));
    }

    default public SetSettingsResponse setSettings(@Nonnull IndexSettings settings, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.setSettingsAsync(settings, requestOptions));
    }

    default public CompletableFuture<SetSettingsResponse> setSettingsAsync(@Nonnull IndexSettings settings) {
        return this.setSettingsAsync(settings, new RequestOptions());
    }

    default public CompletableFuture<SetSettingsResponse> setSettingsAsync(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas) {
        return this.setSettingsAsync(settings, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<SetSettingsResponse> setSettingsAsync(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        requestOptions.addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.setSettingsAsync(settings, requestOptions);
    }

    default public CompletableFuture<SetSettingsResponse> setSettingsAsync(@Nonnull IndexSettings settings, RequestOptions requestOptions) {
        Objects.requireNonNull(settings, "Index settings are required.");
        return this.getTransport().executeRequestAsync(HttpMethod.PUT, "/1/indexes/" + this.getUrlEncodedIndexName() + "/settings", CallType.WRITE, settings, SetSettingsResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public IndexSettings getSettings() {
        return LaunderThrowable.await(this.getSettingsAsync(null));
    }

    default public IndexSettings getSettings(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getSettingsAsync(requestOptions));
    }

    default public CompletableFuture<IndexSettings> getSettingsAsync() {
        return this.getSettingsAsync(null);
    }

    default public CompletableFuture<IndexSettings> getSettingsAsync(RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("getVersion", "2");
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/indexes/" + this.getUrlEncodedIndexName() + "/settings", CallType.READ, IndexSettings.class, requestOptions);
    }
}

