/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchIndex;
import com.algolia.search.SearchIndexBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.iterators.RulesIterable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.DeleteResponse;
import com.algolia.search.models.indexing.SearchResult;
import com.algolia.search.models.rules.Rule;
import com.algolia.search.models.rules.RuleQuery;
import com.algolia.search.models.rules.SaveRuleResponse;
import com.algolia.search.util.AlgoliaUtils;
import com.algolia.search.util.QueryStringUtils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public interface SearchIndexRules<T>
extends SearchIndexBase<T> {
    default public Rule getRule(@Nonnull String objectID) {
        return LaunderThrowable.await(this.getRuleAsync(objectID));
    }

    default public Rule getRule(@Nonnull String objectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getRuleAsync(objectID, requestOptions));
    }

    default public CompletableFuture<Rule> getRuleAsync(@Nonnull String objectID) {
        return this.getRuleAsync(objectID, null);
    }

    default public CompletableFuture<Rule> getRuleAsync(@Nonnull String objectID, RequestOptions requestOptions) {
        Objects.requireNonNull(objectID, "The rule ID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/indexes/" + this.getUrlEncodedIndexName() + "/rules/" + QueryStringUtils.urlEncodeUTF8(objectID), CallType.READ, Rule.class, requestOptions);
    }

    default public SearchResult<Rule> searchRules(@Nonnull RuleQuery query) {
        return LaunderThrowable.await(this.searchRulesAsync(query, null));
    }

    default public SearchResult<Rule> searchRules(@Nonnull RuleQuery query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchRulesAsync(query, requestOptions));
    }

    default public CompletableFuture<SearchResult<Rule>> searchRulesAsync(@Nonnull RuleQuery query) {
        return this.searchRulesAsync(query, null);
    }

    default public CompletableFuture<SearchResult<Rule>> searchRulesAsync(@Nonnull RuleQuery query, RequestOptions requestOptions) {
        Objects.requireNonNull(query, "A search query is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/rules/search", CallType.READ, query, SearchResult.class, Rule.class, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<SearchResult> r = new CompletableFuture<SearchResult>();
            r.complete((SearchResult)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public RulesIterable browseRules() {
        return this.browseRules(1000, null);
    }

    default public RulesIterable browseRules(int hitsPerPage) {
        return this.browseRules(hitsPerPage, null);
    }

    default public RulesIterable browseRules(int hitsPerPage, RequestOptions requestOptions) {
        return new RulesIterable((SearchIndex)this, hitsPerPage, requestOptions);
    }

    default public SaveRuleResponse saveRule(@Nonnull Rule rule) {
        return LaunderThrowable.await(this.saveRuleAsync(rule));
    }

    default public SaveRuleResponse saveRule(@Nonnull Rule rule, @Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.saveRuleAsync(rule, forwardToReplicas));
    }

    default public SaveRuleResponse saveRule(@Nonnull Rule rule, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveRuleAsync(rule, forwardToReplicas, requestOptions));
    }

    default public SaveRuleResponse saveRule(@Nonnull Rule rule, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveRuleAsync(rule, requestOptions));
    }

    default public CompletableFuture<SaveRuleResponse> saveRuleAsync(@Nonnull Rule rule) {
        return this.saveRuleAsync(rule, new RequestOptions());
    }

    default public CompletableFuture<SaveRuleResponse> saveRuleAsync(@Nonnull Rule rule, @Nonnull Boolean forwardToReplicas) {
        return this.saveRuleAsync(rule, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<SaveRuleResponse> saveRuleAsync(@Nonnull Rule rule, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        requestOptions.addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.saveRuleAsync(rule, requestOptions);
    }

    default public CompletableFuture<SaveRuleResponse> saveRuleAsync(@Nonnull Rule rule, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(rule, "A rule is required.");
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(rule.getObjectID()).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be null, empty or white spaces.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.PUT, "/1/indexes/" + this.getUrlEncodedIndexName() + "/rules/" + QueryStringUtils.urlEncodeUTF8(rule.getObjectID()), CallType.WRITE, rule, SaveRuleResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public SaveRuleResponse saveRules(@Nonnull Iterable<Rule> rules) {
        return LaunderThrowable.await(this.saveRulesAsync(rules));
    }

    default public SaveRuleResponse saveRules(@Nonnull Iterable<Rule> rules, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingRules) {
        return LaunderThrowable.await(this.saveRulesAsync(rules, forwardToReplicas, clearExistingRules));
    }

    default public SaveRuleResponse saveRules(@Nonnull Iterable<Rule> rules, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingRules, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveRulesAsync(rules, forwardToReplicas, clearExistingRules, requestOptions));
    }

    default public SaveRuleResponse saveRules(@Nonnull Iterable<Rule> rules, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveRulesAsync(rules, requestOptions));
    }

    default public CompletableFuture<SaveRuleResponse> saveRulesAsync(@Nonnull Iterable<Rule> rules) {
        return this.saveRulesAsync(rules, new RequestOptions());
    }

    default public CompletableFuture<SaveRuleResponse> saveRulesAsync(@Nonnull Iterable<Rule> rules, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingRules) {
        return this.saveRulesAsync(rules, forwardToReplicas, clearExistingRules, new RequestOptions());
    }

    default public CompletableFuture<SaveRuleResponse> saveRulesAsync(@Nonnull Iterable<Rule> rules, @Nonnull Boolean forwardToReplicas, @Nonnull Boolean clearExistingRules, @Nonnull RequestOptions requestOptions) {
        Objects.requireNonNull(requestOptions, "RequestOptions are required.");
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        Objects.requireNonNull(clearExistingRules, "clearExistingRules is required.");
        requestOptions.addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString()).addExtraQueryParameters("clearExistingRules", clearExistingRules.toString());
        return this.saveRulesAsync(rules, requestOptions);
    }

    default public CompletableFuture<SaveRuleResponse> saveRulesAsync(@Nonnull Iterable<Rule> rules, RequestOptions requestOptions) {
        Objects.requireNonNull(rules, "Rules are required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/rules/batch", CallType.WRITE, rules, SaveRuleResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DeleteResponse deleteRule(@Nonnull String objectID) {
        return LaunderThrowable.await(this.deleteRuleAsync(objectID));
    }

    default public DeleteResponse deleteRule(@Nonnull String objectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteRuleAsync(objectID, requestOptions));
    }

    default public CompletableFuture<DeleteResponse> deleteRuleAsync(@Nonnull String objectID) {
        return this.deleteRuleAsync(objectID, null);
    }

    default public CompletableFuture<DeleteResponse> deleteRuleAsync(@Nonnull String objectID, RequestOptions requestOptions) {
        Objects.requireNonNull(objectID, "The objectID is required.");
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.DELETE, "/1/indexes/" + this.getUrlEncodedIndexName() + "/rules/" + QueryStringUtils.urlEncodeUTF8(objectID), CallType.WRITE, DeleteResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public SaveRuleResponse replaceAllRules(@Nonnull Iterable<Rule> rules) {
        return LaunderThrowable.await(this.replaceAllRulesAsync(rules));
    }

    default public SaveRuleResponse replaceAllRules(@Nonnull Iterable<Rule> rules, @Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.replaceAllRulesAsync(rules, forwardToReplicas));
    }

    default public SaveRuleResponse replaceAllRules(@Nonnull Iterable<Rule> rules, @Nonnull RequestOptions requestOptions) {
        return LaunderThrowable.await(this.replaceAllRulesAsync(rules, requestOptions));
    }

    default public CompletableFuture<SaveRuleResponse> replaceAllRulesAsync(@Nonnull Iterable<Rule> rules) {
        return this.saveRulesAsync(rules, false, true, new RequestOptions());
    }

    default public CompletableFuture<SaveRuleResponse> replaceAllRulesAsync(@Nonnull Iterable<Rule> rules, @Nonnull Boolean forwardToReplicas) {
        return this.saveRulesAsync(rules, forwardToReplicas, true, new RequestOptions());
    }

    default public CompletableFuture<SaveRuleResponse> replaceAllRulesAsync(@Nonnull Iterable<Rule> rules, @Nonnull RequestOptions requestOptions) {
        return this.saveRulesAsync(rules, false, true, requestOptions);
    }

    default public DeleteResponse clearRules() {
        return LaunderThrowable.await(this.clearRulesAsync());
    }

    default public DeleteResponse clearRules(@Nonnull Boolean forwardToReplicas) {
        return LaunderThrowable.await(this.clearRulesAsync(forwardToReplicas));
    }

    default public DeleteResponse clearRules(@Nonnull Boolean forwardToReplicas, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clearRulesAsync(forwardToReplicas, requestOptions));
    }

    default public DeleteResponse clearRules(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clearRulesAsync(requestOptions));
    }

    default public CompletableFuture<DeleteResponse> clearRulesAsync() {
        return this.clearRulesAsync(false);
    }

    default public CompletableFuture<DeleteResponse> clearRulesAsync(@Nonnull Boolean forwardToReplicas) {
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        RequestOptions requestOptions = new RequestOptions().addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.clearRulesAsync(requestOptions);
    }

    default public CompletableFuture<DeleteResponse> clearRulesAsync(@Nonnull Boolean forwardToReplicas, RequestOptions requestOptions) {
        Objects.requireNonNull(forwardToReplicas, "ForwardToReplicas is required.");
        requestOptions.addExtraQueryParameters("forwardToReplicas", forwardToReplicas.toString());
        return this.clearRulesAsync(requestOptions);
    }

    default public CompletableFuture<DeleteResponse> clearRulesAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.getUrlEncodedIndexName() + "/rules/clear", CallType.WRITE, DeleteResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }
}

