/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.personalization.GetStrategyResponse;
import com.algolia.search.models.personalization.SetStrategyRequest;
import com.algolia.search.models.personalization.SetStrategyResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface SearchClientPersonalization
extends SearchClientBase {
    default public GetStrategyResponse getPersonalizationStrategy() {
        return LaunderThrowable.await(this.getPersonalizationStrategyAsync());
    }

    default public GetStrategyResponse getPersonalizationStrategy(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getPersonalizationStrategyAsync(requestOptions));
    }

    default public CompletableFuture<GetStrategyResponse> getPersonalizationStrategyAsync() {
        return this.getPersonalizationStrategyAsync(null);
    }

    default public CompletableFuture<GetStrategyResponse> getPersonalizationStrategyAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/recommendation/personalization/strategy", CallType.READ, GetStrategyResponse.class, requestOptions);
    }

    default public SetStrategyResponse setPersonalizationStrategy(@Nonnull SetStrategyRequest request) {
        return LaunderThrowable.await(this.setPersonalizationStrategyAsync(request));
    }

    default public SetStrategyResponse setPersonalizationStrategy(@Nonnull SetStrategyRequest request, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.setPersonalizationStrategyAsync(request, requestOptions));
    }

    default public CompletableFuture<SetStrategyResponse> setPersonalizationStrategyAsync(@Nonnull SetStrategyRequest request) {
        return this.setPersonalizationStrategyAsync(request, null);
    }

    default public CompletableFuture<SetStrategyResponse> setPersonalizationStrategyAsync(@Nonnull SetStrategyRequest request, RequestOptions requestOptions) {
        Objects.requireNonNull(request, "request key is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/recommendation/personalization/strategy", CallType.WRITE, request, SetStrategyResponse.class, requestOptions);
    }
}

