/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.HttpRequester;
import com.algolia.search.HttpTransport;
import com.algolia.search.SearchClientAPIKeys;
import com.algolia.search.SearchClientAdvanced;
import com.algolia.search.SearchClientCopyOperations;
import com.algolia.search.SearchClientMcm;
import com.algolia.search.SearchClientMultipleOperations;
import com.algolia.search.SearchClientPersonalization;
import com.algolia.search.SearchConfig;
import com.algolia.search.SearchIndex;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.util.AlgoliaUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class SearchClient
implements Closeable,
SearchClientMultipleOperations,
SearchClientCopyOperations,
SearchClientMcm,
SearchClientAPIKeys,
SearchClientPersonalization,
SearchClientAdvanced {
    private final HttpTransport transport;
    private final ConfigBase config;

    public SearchClient(@Nonnull SearchConfig config, @Nonnull HttpRequester httpRequester) {
        Objects.requireNonNull(httpRequester, "An httpRequester is required.");
        Objects.requireNonNull(config, "A configuration is required.");
        this.config = config;
        this.transport = new HttpTransport(config, httpRequester);
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    @Override
    public HttpTransport getTransport() {
        return this.transport;
    }

    @Override
    public ConfigBase getConfig() {
        return this.config;
    }

    public SearchIndex<?> initIndex(@Nonnull String indexName) {
        Objects.requireNonNull(indexName, "indexName can't be null.");
        if (AlgoliaUtils.isEmptyWhiteSpace(indexName).booleanValue()) {
            throw new IllegalArgumentException("The index name is required. It can't be empty.");
        }
        return new SearchIndex<Object>(this.transport, this.config, indexName, Object.class);
    }

    public <T> SearchIndex<T> initIndex(@Nonnull String indexName, @Nonnull Class<T> clazz) {
        Objects.requireNonNull(indexName, "indexName can't be null.");
        Objects.requireNonNull(clazz, "A class is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(indexName).booleanValue()) {
            throw new IllegalArgumentException("The index name is required. It can't be empty.");
        }
        return new SearchIndex<T>(this.transport, this.config, indexName, clazz);
    }

    @Override
    public void waitTask(@Nonnull String indexName, long taskID) {
        this.waitTask(indexName, taskID, 100L, null);
    }

    public void waitTask(@Nonnull String indexName, long taskID, long timeToWait) {
        this.waitTask(indexName, taskID, timeToWait, null);
    }

    public void waitTask(@Nonnull String indexName, long taskID, RequestOptions requestOptions) {
        this.waitTask(indexName, taskID, 100L, requestOptions);
    }

    @Override
    public void waitTask(@Nonnull String indexName, long taskID, long timeToWait, RequestOptions requestOptions) {
        Objects.requireNonNull(indexName, "The index name is required.");
        SearchIndex<?> indexToWait = this.initIndex(indexName);
        indexToWait.waitTask(taskID, timeToWait, requestOptions);
    }
}

