/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.StatefulHost;
import com.algolia.search.models.HttpResponse;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.common.RetryOutcome;
import com.algolia.search.util.HttpStatusCodeUtils;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.stream.Collectors;

class RetryStrategy {
    private final List<StatefulHost> hosts;

    RetryStrategy(ConfigBase config) {
        this.hosts = config.getHosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StatefulHost> getTryableHosts(CallType callType) {
        RetryStrategy retryStrategy = this;
        synchronized (retryStrategy) {
            this.resetExpiredHosts();
            if (this.hosts.stream().anyMatch(h -> h.isUp() && h.getAccept().contains((Object)callType))) {
                return this.hosts.stream().filter(h -> h.isUp() && h.getAccept().contains((Object)callType)).collect(Collectors.toList());
            }
            for (StatefulHost host : this.hosts.stream().filter(h -> h.getAccept().contains((Object)callType)).collect(Collectors.toList())) {
                this.reset(host);
            }
            return this.hosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RetryOutcome decide(StatefulHost tryableHost, HttpResponse response) {
        RetryStrategy retryStrategy = this;
        synchronized (retryStrategy) {
            if (!response.isTimedOut() && HttpStatusCodeUtils.isSuccess(response)) {
                tryableHost.setUp(true);
                tryableHost.setLastUse(OffsetDateTime.now(ZoneOffset.UTC));
                return RetryOutcome.SUCCESS;
            }
            if (!response.isTimedOut() && this.isRetryable(response)) {
                tryableHost.setUp(false);
                tryableHost.setLastUse(OffsetDateTime.now(ZoneOffset.UTC));
                return RetryOutcome.RETRY;
            }
            if (response.isTimedOut()) {
                tryableHost.setUp(true);
                tryableHost.setLastUse(OffsetDateTime.now(ZoneOffset.UTC));
                tryableHost.incrementRetryCount();
                return RetryOutcome.RETRY;
            }
            return RetryOutcome.FAILURE;
        }
    }

    private boolean isRetryable(HttpResponse response) {
        boolean isRetryableHttpCode = response.getHttpStatusCode() / 100 != 2 && response.getHttpStatusCode() / 100 != 4;
        return isRetryableHttpCode || response.isNetworkError();
    }

    private void reset(StatefulHost host) {
        host.setUp(true).setRetryCount(0).setLastUse(OffsetDateTime.now(ZoneOffset.UTC));
    }

    private void resetExpiredHosts() {
        for (StatefulHost host : this.hosts) {
            if (host.isUp() || Math.abs(Duration.between(OffsetDateTime.now(ZoneOffset.UTC), host.getLastUse()).getSeconds()) <= 300L) continue;
            this.reset(host);
        }
    }
}

