/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.Defaults;
import com.algolia.search.HttpRequester;
import com.algolia.search.RetryStrategy;
import com.algolia.search.StatefulHost;
import com.algolia.search.exceptions.AlgoliaApiException;
import com.algolia.search.exceptions.AlgoliaRetryException;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.HttpRequest;
import com.algolia.search.models.HttpResponse;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.util.CompletableFutureUtils;
import com.algolia.search.util.QueryStringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

class HttpTransport {
    private final HttpRequester httpRequester;
    private final RetryStrategy retryStrategy;
    private final ConfigBase config;
    private static final Logger LOGGER = Logger.getLogger(HttpTransport.class.getName());

    HttpTransport(@Nonnull ConfigBase config, @Nonnull HttpRequester httpRequester) {
        this.config = config;
        this.httpRequester = httpRequester;
        this.retryStrategy = new RetryStrategy(config);
    }

    void close() throws IOException {
        this.httpRequester.close();
    }

    <TResult> CompletableFuture<TResult> executeRequestAsync(@Nonnull HttpMethod method, @Nonnull String path, @Nonnull CallType callType, Class<TResult> returnClass, RequestOptions requestOptions) {
        return this.executeRequestAsync(method, path, callType, null, returnClass, null, requestOptions);
    }

    <TResult, TData> CompletableFuture<TResult> executeRequestAsync(@Nonnull HttpMethod method, @Nonnull String path, @Nonnull CallType callType, TData data, Class<TResult> returnClazz, RequestOptions requestOptions) {
        return this.executeRequestAsync(method, path, callType, data, returnClazz, null, requestOptions);
    }

    <TResult, TInnerResult, TData> CompletableFuture<TResult> executeRequestAsync(@Nonnull HttpMethod method, @Nonnull String path, @Nonnull CallType callType, TData data, Class<TResult> returnClazz, Class<TInnerResult> innerClazz, RequestOptions requestOptions) {
        Iterator<StatefulHost> hosts = this.retryStrategy.getTryableHosts(callType).iterator();
        HttpRequest request = this.buildRequest(method, path, callType, requestOptions, data);
        JavaType type = innerClazz == null ? Defaults.getObjectMapper().getTypeFactory().constructType(returnClazz) : Defaults.getObjectMapper().getTypeFactory().constructParametricType(returnClazz, new Class[]{innerClazz});
        return this.executeWithRetry(hosts, request, type);
    }

    private <TResult> CompletableFuture<TResult> executeWithRetry(@Nonnull Iterator<StatefulHost> hosts, @Nonnull HttpRequest request, @Nonnull JavaType type) {
        if (!hosts.hasNext()) {
            return CompletableFutureUtils.failedFuture(new AlgoliaRetryException("All hosts are unreachable"));
        }
        StatefulHost currentHost = hosts.next();
        request.setUri(this.buildURI(currentHost.getUrl(), request.getMethodPath()));
        request.incrementTimeout(currentHost.getRetryCount());
        return this.httpRequester.performRequestAsync(request).thenComposeAsync(resp -> {
            switch (this.retryStrategy.decide(currentHost, (HttpResponse)resp)) {
                case SUCCESS: {
                    try (InputStream dataStream = resp.getBody();){
                        Object result = Defaults.getObjectMapper().readValue(dataStream, type);
                        this.logResponse(result);
                        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(result);
                        return completableFuture;
                    }
                    catch (IOException e) {
                        return CompletableFutureUtils.failedFuture(new AlgoliaRuntimeException(e));
                    }
                }
                case RETRY: {
                    return this.executeWithRetry(hosts, request, type);
                }
                case FAILURE: {
                    return CompletableFutureUtils.failedFuture(new AlgoliaApiException(resp.getError(), resp.getHttpStatusCode()));
                }
            }
            return CompletableFutureUtils.failedFuture(new AlgoliaRetryException("Error while processing the retry strategy decision."));
        }, (Executor)this.config.getExecutor());
    }

    private <TData> HttpRequest buildRequest(@Nonnull HttpMethod method, @Nonnull String methodPath, @Nonnull CallType callType, RequestOptions requestOptions, TData data) {
        Map<String, String> headersToSend = requestOptions != null ? this.buildHeaders(requestOptions.getExtraHeaders()) : this.buildHeaders();
        String fullPath = requestOptions != null ? this.buildFullPath(methodPath, requestOptions.getExtraQueryParams()) : this.buildFullPath(methodPath);
        int timeout = requestOptions != null && requestOptions.getTimeout() != null ? requestOptions.getTimeout().intValue() : this.getTimeOut(callType);
        HttpRequest request = new HttpRequest(method, fullPath, headersToSend, timeout, this.config.getCompressionType());
        if (data != null) {
            request.setBody(this.serializeJSON(data, request));
            this.logRequest(request, data);
        }
        return request;
    }

    /*
     * Exception decompiling
     */
    private <TData> InputStream serializeJSON(TData data, HttpRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL buildURI(String host, String fullPath) {
        try {
            return new URL("https://" + host + fullPath);
        }
        catch (MalformedURLException e) {
            throw new AlgoliaRuntimeException("Error while building the URL", e);
        }
    }

    private String buildFullPath(String methodPath) {
        return this.buildFullPath(methodPath, null);
    }

    private String buildFullPath(String methodPath, Map<String, String> optionalQueryParameters) {
        if (optionalQueryParameters == null) {
            return methodPath;
        }
        String queryParameters = QueryStringUtils.buildQueryString(optionalQueryParameters);
        return methodPath + queryParameters;
    }

    private Map<String, String> buildHeaders() {
        return this.buildHeaders(null);
    }

    private Map<String, String> buildHeaders(Map<String, String> optionalHeaders) {
        if (optionalHeaders == null) {
            return this.config.getDefaultHeaders();
        }
        this.config.getDefaultHeaders().forEach(optionalHeaders::putIfAbsent);
        return optionalHeaders;
    }

    private int getTimeOut(CallType callType) {
        switch (callType) {
            case READ: {
                return this.config.getReadTimeOut() == null ? 5000 : this.config.getReadTimeOut();
            }
            case WRITE: {
                return this.config.getWriteTimeOut() == null ? 30000 : this.config.getWriteTimeOut();
            }
        }
        return 30000;
    }

    private <T> void logRequest(HttpRequest request, T data) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("\n Method: %s \n Path: %s \n Headers: %s", request.getMethod().toString(), request.getMethodPath(), request.getHeaders()));
            try {
                LOGGER.finest(String.format("Request body: \n %s ", Defaults.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(data)));
            }
            catch (JsonProcessingException e) {
                throw new AlgoliaRuntimeException("Error while serializing the request", e);
            }
        }
    }

    private <TResult> void logResponse(TResult result) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Response body: %s \n", Defaults.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(result)));
        }
    }
}

