/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.http;

import com.algolia.search.http.HttpMethod;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class AlgoliaRequest<T> {
    private final HttpMethod method;
    private final boolean isSearch;
    private final List<String> path;
    private Map<String, String> parameters = Maps.newHashMap();
    private Object data = null;
    private Class<T> resultClass;
    private Class<T> collectionClass;
    private Class<?> elementClass;

    public AlgoliaRequest(HttpMethod method, boolean isSearch, List<String> path, Class<T> resultClass) {
        this.method = method;
        this.isSearch = isSearch;
        this.path = path;
        this.resultClass = resultClass;
    }

    public AlgoliaRequest(HttpMethod method, boolean isSearch, List<String> path, Class<T> collectionClass, Class<?> elementClass) {
        this.method = method;
        this.isSearch = isSearch;
        this.path = path;
        this.collectionClass = collectionClass;
        this.elementClass = elementClass;
    }

    JavaType getJavaType(TypeFactory factory) {
        if (this.resultClass != null) {
            return factory.constructType(this.resultClass);
        }
        return factory.constructParametricType(this.collectionClass, new Class[]{this.elementClass});
    }

    HttpMethod getMethod() {
        return this.method;
    }

    public boolean isSearch() {
        return this.isSearch;
    }

    List<String> getPath() {
        return this.path;
    }

    boolean hasData() {
        return this.data != null;
    }

    Object getData() {
        return this.data;
    }

    public AlgoliaRequest<T> setData(Object data) {
        this.data = data;
        return this;
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    public AlgoliaRequest<T> setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }
}

