/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.iterators;

import com.algolia.search.AsyncIndex;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

abstract class AsyncAlgoliaIterator<E>
implements Iterator<E> {
    protected final AsyncIndex<?> index;
    protected final Integer hitsPerPage;
    private Integer currentPage = 0;
    private Iterator<E> currentIterator = null;
    private boolean isFirstRequest = true;

    AsyncAlgoliaIterator(@Nonnull AsyncIndex<?> index) {
        this(index, 1000);
    }

    AsyncAlgoliaIterator(@Nonnull AsyncIndex<?> index, @Nonnull Integer hitsPerPage) {
        this.index = index;
        this.hitsPerPage = hitsPerPage;
    }

    @Override
    public boolean hasNext() {
        if (this.isFirstRequest) {
            this.executeQueryAndSetInnerState();
            this.isFirstRequest = false;
        }
        if (this.currentPage != null && !this.currentIterator.hasNext()) {
            this.executeQueryAndSetInnerState();
        }
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.executeQueryAndSetInnerState();
            this.isFirstRequest = false;
        }
        return this.currentIterator.next();
    }

    private void executeQueryAndSetInnerState() {
        List<E> result = this.doQueryToGetHits(this.currentPage);
        this.currentIterator = result.iterator();
        this.currentPage = result.size() <= this.hitsPerPage ? Integer.valueOf(this.currentPage + 1) : null;
    }

    abstract List<E> doQueryToGetHits(Integer var1);
}

