/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskIndexing;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;

public interface SyncObjects<T>
extends SyncBaseIndex<T> {
    default public TaskIndexing addObject(@Nonnull T object) throws AlgoliaException {
        return this.addObject(object, new RequestOptions());
    }

    default public TaskIndexing addObject(@Nonnull T object, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addObject(this.getName(), object, requestOptions);
    }

    default public TaskIndexing addObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.addObject(objectID, object, new RequestOptions());
    }

    default public TaskIndexing addObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addObject(this.getName(), objectID, object, requestOptions);
    }

    default public TaskSingleIndex addObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.addObjects(objects, new RequestOptions());
    }

    default public TaskSingleIndex addObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addObjects(this.getName(), objects, requestOptions);
    }

    default public Optional<T> getObject(@Nonnull String objectID) throws AlgoliaException {
        return this.getObject(objectID, new RequestOptions());
    }

    default public Optional<T> getObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getObject(this.getName(), objectID, this.getKlass(), requestOptions);
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.getObjects(objectIDs, new RequestOptions());
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getObjects(this.getName(), objectIDs, this.getKlass(), requestOptions);
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) throws AlgoliaException {
        return this.getObjects(objectIDs, attributesToRetrieve, new RequestOptions());
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getObjects(this.getName(), objectIDs, attributesToRetrieve, this.getKlass(), requestOptions);
    }

    default public Task saveObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.saveObject(objectID, object, new RequestOptions());
    }

    default public Task saveObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().saveObject(this.getName(), objectID, object, requestOptions);
    }

    default public TaskSingleIndex saveObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.saveObjects(objects, new RequestOptions());
    }

    default public TaskSingleIndex saveObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().saveObjects(this.getName(), objects, requestOptions);
    }

    default public void replaceAllObjects(@Nonnull Iterable<T> objects, boolean safe) throws AlgoliaException {
        this.replaceAllObjects(objects, safe, new RequestOptions());
    }

    default public void replaceAllObjects(@Nonnull Iterable<T> objects, boolean safe, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        String tmpName = this.getName() + "_tmp_" + UUID.randomUUID().toString();
        ArrayList<String> scope = new ArrayList<String>(Arrays.asList("rules", "settings", "synonyms"));
        ArrayList<Object> batchResponses = new ArrayList<Object>();
        Task copyIndexResponse = this.getApiClient().copyIndex(this.getName(), tmpName, scope, requestOptions);
        if (safe) {
            this.getApiClient().waitTask(copyIndexResponse);
        }
        ArrayList<T> records = new ArrayList<T>();
        for (T t : objects) {
            if (records.size() == 1000) {
                TaskSingleIndex batchResponse = this.getApiClient().saveObjects(tmpName, records, requestOptions);
                if (safe) {
                    batchResponses.add(batchResponse);
                }
                records.clear();
            }
            records.add(t);
        }
        if (records.size() > 0) {
            TaskSingleIndex batchResponse = this.getApiClient().saveObjects(tmpName, records, requestOptions);
            if (safe) {
                batchResponses.add(batchResponse);
            }
        }
        if (safe) {
            for (Task task : batchResponses) {
                this.getApiClient().waitTask(task);
            }
        }
        Task moveIndexResponse = this.getApiClient().moveIndex(tmpName, this.getName(), requestOptions);
        if (safe) {
            this.getApiClient().waitTask(moveIndexResponse);
        }
    }

    default public Task deleteObject(@Nonnull String objectID) throws AlgoliaException {
        return this.deleteObject(objectID, new RequestOptions());
    }

    default public Task deleteObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteObject(this.getName(), objectID, requestOptions);
    }

    default public TaskSingleIndex deleteObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.deleteObjects(objectIDs, new RequestOptions());
    }

    default public TaskSingleIndex deleteObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteObjects(this.getName(), objectIDs, requestOptions);
    }
}

