/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.Index;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.iterators.IndexIterable;
import com.algolia.search.iterators.RulesIterable;
import com.algolia.search.iterators.SynonymsIterable;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SyncAccountClient {
    public static <T> List<Long> copyIndex(@Nonnull Index<T> sourceIndex, @Nonnull Index<T> destinationIndex) throws AlgoliaException {
        return SyncAccountClient.copyIndex(sourceIndex, destinationIndex, new RequestOptions());
    }

    public static <T> List<Long> copyIndex(@Nonnull Index<T> sourceIndex, @Nonnull Index<T> destinationIndex, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        if (sourceIndex.getApiClient().configuration.getApplicationId().equals(destinationIndex.getApiClient().configuration.getApplicationId())) {
            throw new AlgoliaException("Source and Destination indices should not be on the same application.");
        }
        if (destinationIndex.getSettings() != null) {
            throw new AlgoliaException("Destination index already exists. Please delete it before copying index across applications.");
        }
        ArrayList<Long> taskIds = new ArrayList<Long>();
        IndexSettings srcSettings = sourceIndex.getSettings();
        Task settingsTask = destinationIndex.setSettings(srcSettings, requestOptions);
        taskIds.add((Long)settingsTask.getTaskID());
        SynonymsIterable synonymsIterable = new SynonymsIterable(sourceIndex);
        ArrayList synonyms = Lists.newArrayList((Iterable)synonymsIterable);
        Task synonymsTask = destinationIndex.batchSynonyms((List<AbstractSynonym>)synonyms, requestOptions);
        taskIds.add((Long)synonymsTask.getTaskID());
        RulesIterable rulesIterable = new RulesIterable(sourceIndex);
        ArrayList rules = Lists.newArrayList((Iterable)rulesIterable);
        Task rulesTask = destinationIndex.batchRules((List<Rule>)rules, requestOptions);
        taskIds.add((Long)rulesTask.getTaskID());
        ArrayList records = new ArrayList();
        IndexIterable iterator = sourceIndex.browse(new Query(""));
        for (Object object : iterator) {
            if (records.size() == 1000) {
                TaskSingleIndex task = destinationIndex.addObjects(records, requestOptions);
                taskIds.add((Long)task.getTaskID());
                records.clear();
            }
            records.add(object);
        }
        if (records.size() > 0) {
            TaskSingleIndex task = destinationIndex.addObjects(records, requestOptions);
            taskIds.add((Long)task.getTaskID());
        }
        return taskIds;
    }
}

