/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncBaseIndex;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.async.AsyncTask;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface AsyncSettings<T>
extends AsyncBaseIndex<T> {
    default public CompletableFuture<IndexSettings> getSettings() {
        return this.getSettings(new RequestOptions());
    }

    default public CompletableFuture<IndexSettings> getSettings(@Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getSettings(this.getName(), requestOptions);
    }

    default public CompletableFuture<AsyncTask> setSettings(@Nonnull IndexSettings settings) {
        return this.setSettings(settings, false);
    }

    default public CompletableFuture<AsyncTask> setSettings(@Nonnull IndexSettings settings, @Nonnull RequestOptions requestOptions) {
        return this.setSettings(settings, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas) {
        return this.setSettings(settings, forwardToReplicas, new RequestOptions());
    }

    default public CompletableFuture<AsyncTask> setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().setSettings(this.getName(), settings, forwardToReplicas, requestOptions);
    }
}

