/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.iterators.AsyncIndexIterable;
import com.algolia.search.iterators.AsyncRulesIterable;
import com.algolia.search.iterators.AsyncSynonymsIterable;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;

public class AsyncAccountClient {
    public static <T> List<Long> copyIndex(@Nonnull AsyncIndex<T> sourceIndex, @Nonnull AsyncIndex<T> destinationIndex) throws AlgoliaException, ExecutionException, InterruptedException {
        return AsyncAccountClient.copyIndex(sourceIndex, destinationIndex, new RequestOptions());
    }

    public static <T> List<Long> copyIndex(@Nonnull AsyncIndex<T> sourceIndex, @Nonnull AsyncIndex<T> destinationIndex, @Nonnull RequestOptions requestOptions) throws AlgoliaException, ExecutionException, InterruptedException {
        if (sourceIndex.getApiClient().configuration.getApplicationId().equals(destinationIndex.getApiClient().configuration.getApplicationId())) {
            throw new AlgoliaException("Source and Destination indices should not be on the same application.");
        }
        if (destinationIndex.getSettings().get() != null) {
            throw new AlgoliaException("Destination index already exists. Please delete it before copying index across applications.");
        }
        ArrayList<Long> taskIds = new ArrayList<Long>();
        IndexSettings srcSettings = sourceIndex.getSettings().get();
        AsyncTask settingsTask = destinationIndex.setSettings(srcSettings, requestOptions).get();
        taskIds.add((Long)settingsTask.getTaskID());
        AsyncSynonymsIterable synonymsIterable = new AsyncSynonymsIterable(sourceIndex);
        ArrayList synonyms = Lists.newArrayList((Iterable)synonymsIterable);
        AsyncTask synonymsTask = destinationIndex.batchSynonyms((List<AbstractSynonym>)synonyms, requestOptions).get();
        taskIds.add((Long)synonymsTask.getTaskID());
        AsyncRulesIterable rulesIterable = new AsyncRulesIterable(sourceIndex);
        ArrayList rules = Lists.newArrayList((Iterable)rulesIterable);
        AsyncTask rulesTask = destinationIndex.batchRules((List<Rule>)rules, requestOptions).get();
        taskIds.add((Long)rulesTask.getTaskID());
        ArrayList records = new ArrayList();
        AsyncIndexIterable iterator = sourceIndex.browse(new Query(""));
        for (Object object : iterator) {
            if (records.size() == 1000) {
                AsyncTask task = destinationIndex.addObjects(records, requestOptions).get();
                taskIds.add((Long)task.getTaskID());
                records.clear();
            }
            records.add(object);
        }
        if (records.size() > 0) {
            AsyncTask task = destinationIndex.addObjects(records, requestOptions).get();
            taskIds.add((Long)task.getTaskID());
        }
        return taskIds;
    }
}

