/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.RuleQuery;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.responses.SearchRuleResult;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface SyncRules<T>
extends SyncBaseIndex<T> {
    default public Task saveRule(@Nonnull String queryRuleID, @Nonnull Rule content) throws AlgoliaException {
        return this.saveRule(queryRuleID, content, false);
    }

    default public Task saveRule(@Nonnull String queryRuleID, @Nonnull Rule content, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.saveRule(queryRuleID, content, false, requestOptions);
    }

    default public Task saveRule(@Nonnull String queryRuleID, @Nonnull Rule content, boolean forwardToReplicas) throws AlgoliaException {
        return this.saveRule(queryRuleID, content, forwardToReplicas, new RequestOptions());
    }

    default public Task saveRule(@Nonnull String queryRuleID, @Nonnull Rule content, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        if (queryRuleID.isEmpty()) {
            throw new AlgoliaException("Cannot save rule with empty queryRuleID");
        }
        return this.getApiClient().saveRule(this.getName(), queryRuleID, content, forwardToReplicas, requestOptions);
    }

    default public Optional<Rule> getRule(@Nonnull String ruleId) throws AlgoliaException {
        return this.getRule(ruleId, new RequestOptions());
    }

    default public Optional<Rule> getRule(@Nonnull String ruleId, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getRule(this.getName(), ruleId, requestOptions);
    }

    default public Task deleteRule(@Nonnull String ruleId) throws AlgoliaException {
        return this.deleteRule(ruleId, false, new RequestOptions());
    }

    default public Task deleteRule(@Nonnull String ruleId, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.deleteRule(ruleId, false, requestOptions);
    }

    default public Task deleteRule(@Nonnull String ruleId, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteRule(this.getName(), ruleId, forwardToReplicas, requestOptions);
    }

    default public Task clearRules() throws AlgoliaException {
        return this.clearRules(false);
    }

    default public Task clearRules(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.clearRules(false, requestOptions);
    }

    default public Task clearRules(boolean forwardToReplicas) throws AlgoliaException {
        return this.clearRules(forwardToReplicas, new RequestOptions());
    }

    default public Task clearRules(boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().clearRules(this.getName(), forwardToReplicas, requestOptions);
    }

    default public SearchRuleResult searchRules(@Nonnull RuleQuery query) throws AlgoliaException {
        return this.searchRules(query, new RequestOptions());
    }

    default public SearchRuleResult searchRules(@Nonnull RuleQuery query, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().searchRules(this.getName(), query, requestOptions);
    }

    default public Task batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas, boolean clearExistingRules) throws AlgoliaException {
        return this.batchRules(rules, forwardToReplicas, clearExistingRules, new RequestOptions());
    }

    default public Task batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas, boolean clearExistingRules, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().batchRules(this.getName(), rules, forwardToReplicas, clearExistingRules, requestOptions);
    }

    default public Task batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchRules(rules, forwardToReplicas, false);
    }

    default public Task batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.batchRules(rules, forwardToReplicas, false, requestOptions);
    }

    default public Task batchRules(@Nonnull List<Rule> rules) throws AlgoliaException {
        return this.batchRules(rules, false, false);
    }

    default public Task batchRules(@Nonnull List<Rule> rules, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.batchRules(rules, false, false, requestOptions);
    }
}

