/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncAPIClient;
import com.algolia.search.AsyncAPIClientConfiguration;
import com.algolia.search.GenericAPIClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;

public abstract class AsyncAPIClientBuilder
extends GenericAPIClientBuilder {
    public AsyncAPIClientBuilder(@Nonnull String applicationId, @Nonnull String apiKey) {
        super(applicationId, apiKey);
    }

    @Override
    public AsyncAPIClientBuilder setUserAgent(@Nonnull String customAgent, @Nonnull String customAgentVersion) {
        super.setUserAgent(customAgent, customAgentVersion);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setExtraHeader(@Nonnull String key, String value) {
        super.setExtraHeader(key, value);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setReadTimeout(int readTimeout) {
        super.setReadTimeout(readTimeout);
        return this;
    }

    @Override
    public AsyncAPIClientBuilder setObjectMapper(@Nonnull ObjectMapper objectMapper) {
        super.setObjectMapper(objectMapper);
        return this;
    }

    protected abstract AsyncAPIClient build(@Nonnull AsyncAPIClientConfiguration var1);

    public AsyncAPIClient build() {
        return this.build(Executors.newFixedThreadPool(10));
    }

    public AsyncAPIClient build(ExecutorService executor) {
        return this.build(((AsyncAPIClientConfiguration)((AsyncAPIClientConfiguration)((AsyncAPIClientConfiguration)new AsyncAPIClientConfiguration().setExecutor(executor).setApplicationId(this.applicationId).setApiKey(this.apiKey).setObjectMapper(this.objectMapper).setBuildHosts((List)this.generateBuildHosts())).setQueryHosts((List)this.generateQueryHosts())).setHeaders((Map)this.generateHeaders())).setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout));
    }
}

