/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.Task;
import java.util.List;
import javax.annotation.Nonnull;

public interface SyncIndexCRUD<T>
extends SyncBaseIndex<T> {
    default public Task delete() throws AlgoliaException {
        return this.delete(RequestOptions.empty);
    }

    default public Task delete(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteIndex(this.getName(), requestOptions);
    }

    default public Task clear() throws AlgoliaException {
        return this.clear(RequestOptions.empty);
    }

    default public Task clear(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().clearIndex(this.getName(), requestOptions);
    }

    default public Task moveTo(@Nonnull String dstIndexName) throws AlgoliaException {
        return this.moveTo(dstIndexName, RequestOptions.empty);
    }

    default public Task moveTo(@Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().moveIndex(this.getName(), dstIndexName, requestOptions);
    }

    default public Task copyTo(@Nonnull String dstIndexName) throws AlgoliaException {
        return this.copyTo(dstIndexName, RequestOptions.empty);
    }

    default public Task copyTo(@Nonnull String dstIndexName, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().copyIndex(this.getName(), dstIndexName, null, requestOptions);
    }

    default public Task copyTo(@Nonnull String dstIndexName, @Nonnull List<String> scope, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().copyIndex(this.getName(), dstIndexName, scope, requestOptions);
    }

    default public Task copyTo(@Nonnull String dstIndexName, @Nonnull List<String> scope) throws AlgoliaException {
        return this.copyTo(dstIndexName, scope, RequestOptions.empty);
    }
}

