/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.objects;

import com.algolia.search.objects.Distinct;
import com.algolia.search.objects.IgnorePlurals;
import com.algolia.search.objects.RemoveStopWords;
import com.algolia.search.objects.TypoTolerance;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Query
implements Serializable {
    protected Distinct distinct;
    protected Boolean getRankingInfo;
    protected List<String> numericFilters;
    protected List<String> tagFilters;
    protected Boolean analytics;
    protected String analyticsTags;
    protected Boolean synonyms;
    protected Boolean replaceSynonymsInHighlight;
    protected Integer minProximity;
    protected List<String> responseFields;
    protected Long maxFacetHits;
    protected Boolean percentileComputation;
    protected List<String> attributesToRetrieve;
    protected List<String> restrictSearchableAttributes;
    protected String filters;
    protected String facets;
    protected Long maxValuesPerFacet;
    protected List<String> facetFilters;
    protected Boolean facetingAfterDistinct;
    protected String sortFacetValuesBy;
    protected String aroundLatLng;
    protected Boolean aroundLatLngViaIP;
    protected Object aroundRadius;
    protected Integer aroundPrecision;
    protected Integer minimumAroundRadius;
    protected List<String> insideBoundingBox;
    protected List<String> insidePolygon;
    protected List<String> attributesToHighlight;
    protected List<String> attributesToSnippet;
    protected String highlightPreTag;
    protected String highlightPostTag;
    protected String snippetEllipsisText;
    protected Boolean restrictHighlightAndSnippetArrays;
    protected Long page;
    protected Long hitsPerPage;
    protected Long offset;
    protected Long length;
    protected Boolean enableRules;
    protected List<String> ruleContexts;
    protected String queryType;
    protected RemoveWordsType removeWordsIfNoResults;
    protected Boolean advancedSyntax;
    protected List<String> optionalWords;
    protected RemoveStopWords removeStopWords;
    protected List<String> disableExactOnAttributes;
    protected String exactOnSingleWordQuery;
    protected List<String> alternativesAsExact;
    @JsonProperty(value="query")
    protected String query;
    protected Integer minWordSizefor1Typo;
    protected Integer minWordSizefor2Typos;
    protected TypoTolerance typoTolerance;
    protected Boolean allowTyposOnNumericTokens;
    protected IgnorePlurals ignorePlurals;
    protected List<String> disableTypoToleranceOnAttributes;
    protected String userToken;
    protected Integer validUntil;
    protected List<String> restrictIndices;
    protected String restrictSources;
    protected String cursor;
    @JsonIgnore
    protected Map<String, Object> customParameters = new HashMap<String, Object>();

    public Query() {
    }

    public Query(String query) {
        this.query = query;
    }

    private Map<String, String> toQueryParam() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        if (this.distinct != null) {
            builder = this.add(builder, "distinct", this.distinct.getInsideValue());
        }
        builder = this.add(builder, "getRankingInfo", this.getRankingInfo);
        builder = this.add(builder, "numericFilters", this.numericFilters);
        builder = this.add(builder, "tagFilters", this.tagFilters);
        builder = this.add(builder, "analytics", this.analytics);
        builder = this.add(builder, "analyticsTags", this.analyticsTags);
        builder = this.add(builder, "synonyms", this.synonyms);
        builder = this.add(builder, "replaceSynonymsInHighlight", this.replaceSynonymsInHighlight);
        builder = this.add(builder, "minProximity", this.minProximity);
        builder = this.add(builder, "responseFields", this.responseFields);
        builder = this.add(builder, "maxFacetHits", this.maxFacetHits);
        builder = this.add(builder, "percentileComputation", this.percentileComputation);
        builder = this.add(builder, "attributesToRetrieve", this.attributesToRetrieve);
        builder = this.add(builder, "restrictSearchableAttributes", this.restrictSearchableAttributes);
        builder = this.add(builder, "filters", this.filters);
        builder = this.add(builder, "facets", this.facets);
        builder = this.add(builder, "maxValuesPerFacet", this.maxValuesPerFacet);
        builder = this.add(builder, "facetFilters", this.facetFilters);
        builder = this.add(builder, "facetingAfterDistinct", this.facetingAfterDistinct);
        builder = this.add(builder, "sortFacetValuesBy", this.sortFacetValuesBy);
        builder = this.add(builder, "aroundLatLng", this.aroundLatLng);
        builder = this.add(builder, "aroundLatLngViaIP", this.aroundLatLngViaIP);
        builder = this.add(builder, "aroundRadius", this.aroundRadius);
        builder = this.add(builder, "aroundPrecision", this.aroundPrecision);
        builder = this.add(builder, "minimumAroundRadius", this.minimumAroundRadius);
        builder = this.add(builder, "insideBoundingBox", this.insideBoundingBox);
        builder = this.add(builder, "insidePolygon", this.insidePolygon);
        builder = this.add(builder, "attributesToHighlight", this.attributesToHighlight);
        builder = this.add(builder, "attributesToSnippet", this.attributesToSnippet);
        builder = this.add(builder, "highlightPreTag", this.highlightPreTag);
        builder = this.add(builder, "highlightPostTag", this.highlightPostTag);
        builder = this.add(builder, "snippetEllipsisText", this.snippetEllipsisText);
        builder = this.add(builder, "restrictHighlightAndSnippetArrays", this.restrictHighlightAndSnippetArrays);
        builder = this.add(builder, "page", this.page);
        builder = this.add(builder, "hitsPerPage", this.hitsPerPage);
        builder = this.add(builder, "offset", this.offset);
        builder = this.add(builder, "length", this.length);
        builder = this.add(builder, "enableRules", this.enableRules);
        builder = this.add(builder, "ruleContexts", this.ruleContexts);
        builder = this.add(builder, "queryType", this.queryType);
        builder = this.add(builder, "removeWordsIfNoResults", this.removeWordsIfNoResults);
        builder = this.add(builder, "advancedSyntax", this.advancedSyntax);
        builder = this.add(builder, "optionalWords", this.optionalWords);
        if (this.removeStopWords != null) {
            builder = this.add(builder, "removeStopWords", this.removeStopWords.getInsideValue());
        }
        builder = this.add(builder, "disableExactOnAttributes", this.disableExactOnAttributes);
        builder = this.add(builder, "exactOnSingleWordQuery", this.exactOnSingleWordQuery);
        builder = this.add(builder, "alternativesAsExact", this.alternativesAsExact);
        builder = this.add(builder, "query", this.query);
        builder = this.add(builder, "minWordSizefor1Typo", this.minWordSizefor1Typo);
        builder = this.add(builder, "minWordSizefor2Typos", this.minWordSizefor2Typos);
        builder = this.add(builder, "typoTolerance", this.typoTolerance);
        builder = this.add(builder, "allowTyposOnNumericTokens", this.allowTyposOnNumericTokens);
        if (this.ignorePlurals != null) {
            builder = this.add(builder, "ignorePlurals", this.ignorePlurals.getInsideValue());
        }
        builder = this.add(builder, "disableTypoToleranceOnAttributes", this.disableTypoToleranceOnAttributes);
        builder = this.add(builder, "userToken", this.userToken);
        builder = this.add(builder, "validUntil", this.validUntil);
        builder = this.add(builder, "restrictIndices", this.restrictIndices);
        builder = this.add(builder, "restrictSources", this.restrictSources);
        builder = this.add(builder, "cursor", this.cursor);
        for (Map.Entry<String, Object> entry : this.customParameters.entrySet()) {
            builder = this.add(builder, entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Object value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Enum<?> value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, String value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value);
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Boolean value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Integer value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, List<String> attributes) {
        if (attributes == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)String.join((CharSequence)",", attributes));
    }

    public String toParam() {
        StringBuilder builder = new StringBuilder();
        boolean firstOne = true;
        for (Map.Entry<String, String> entry : this.toQueryParam().entrySet()) {
            try {
                if (!firstOne) {
                    builder = builder.append("&");
                }
                builder = builder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            firstOne = false;
        }
        return builder.toString();
    }

    public Query setAroundRadius(Integer aroundRadius) {
        this.aroundRadius = aroundRadius;
        return this;
    }

    @JsonIgnore
    public Query setAroundRadiusAll() {
        this.aroundRadius = "all";
        return this;
    }

    @JsonAnySetter
    public Query addCustomParameter(String key, String value) {
        this.customParameters.put(key, value);
        return this;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public Query setDistinct(Distinct distinct) {
        this.distinct = distinct;
        return this;
    }

    public Boolean getGetRankingInfo() {
        return this.getRankingInfo;
    }

    public Query setGetRankingInfo(Boolean getRankingInfo) {
        this.getRankingInfo = getRankingInfo;
        return this;
    }

    public List<String> getNumericFilters() {
        return this.numericFilters;
    }

    public Query setNumericFilters(List<String> numericFilters) {
        this.numericFilters = numericFilters;
        return this;
    }

    public List<String> getTagFilters() {
        return this.tagFilters;
    }

    public Query setTagFilters(List<String> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public Boolean getAnalytics() {
        return this.analytics;
    }

    public Query setAnalytics(Boolean analytics) {
        this.analytics = analytics;
        return this;
    }

    public String getAnalyticsTags() {
        return this.analyticsTags;
    }

    public Query setAnalyticsTags(String analyticsTags) {
        this.analyticsTags = analyticsTags;
        return this;
    }

    public Boolean getSynonyms() {
        return this.synonyms;
    }

    public Query setSynonyms(Boolean synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public Boolean getReplaceSynonymsInHighlight() {
        return this.replaceSynonymsInHighlight;
    }

    public Query setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
        this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
        return this;
    }

    public Integer getMinProximity() {
        return this.minProximity;
    }

    public Query setMinProximity(Integer minProximity) {
        this.minProximity = minProximity;
        return this;
    }

    public List<String> getResponseFields() {
        return this.responseFields;
    }

    public Query setResponseFields(List<String> responseFields) {
        this.responseFields = responseFields;
        return this;
    }

    public Long getMaxFacetHits() {
        return this.maxFacetHits;
    }

    @JsonSetter
    public Query setMaxFacetHits(Long maxFacetHits) {
        this.maxFacetHits = maxFacetHits;
        return this;
    }

    public Query setMaxFacetHits(Integer maxFacetHits) {
        return this.setMaxFacetHits(maxFacetHits.longValue());
    }

    public Boolean getPercentileComputation() {
        return this.percentileComputation;
    }

    public Query setPercentileComputation(Boolean percentileComputation) {
        this.percentileComputation = percentileComputation;
        return this;
    }

    public List<String> getAttributesToRetrieve() {
        return this.attributesToRetrieve;
    }

    public Query setAttributesToRetrieve(List<String> attributesToRetrieve) {
        this.attributesToRetrieve = attributesToRetrieve;
        return this;
    }

    public List<String> getRestrictSearchableAttributes() {
        return this.restrictSearchableAttributes;
    }

    public Query setRestrictSearchableAttributes(List<String> restrictSearchableAttributes) {
        this.restrictSearchableAttributes = restrictSearchableAttributes;
        return this;
    }

    public String getFilters() {
        return this.filters;
    }

    public Query setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public String getFacets() {
        return this.facets;
    }

    public Query setFacets(String facets) {
        this.facets = facets;
        return this;
    }

    public Long getMaxValuesPerFacet() {
        return this.maxValuesPerFacet;
    }

    @JsonSetter
    public Query setMaxValuesPerFacet(Long maxValuesPerFacet) {
        this.maxValuesPerFacet = maxValuesPerFacet;
        return this;
    }

    public Query setMaxValuesPerFacet(Integer maxValuesPerFacet) {
        return this.setMaxValuesPerFacet(maxValuesPerFacet.longValue());
    }

    public List<String> getFacetFilters() {
        return this.facetFilters;
    }

    public Query setFacetFilters(List<String> facetFilters) {
        this.facetFilters = facetFilters;
        return this;
    }

    public Boolean getFacetingAfterDistinct() {
        return this.facetingAfterDistinct;
    }

    public Query setFacetingAfterDistinct(Boolean facetingAfterDistinct) {
        this.facetingAfterDistinct = facetingAfterDistinct;
        return this;
    }

    public String getAroundLatLng() {
        return this.aroundLatLng;
    }

    public Query setAroundLatLng(String aroundLatLng) {
        this.aroundLatLng = aroundLatLng;
        return this;
    }

    public Boolean getAroundLatLngViaIP() {
        return this.aroundLatLngViaIP;
    }

    public Query setAroundLatLngViaIP(Boolean aroundLatLngViaIP) {
        this.aroundLatLngViaIP = aroundLatLngViaIP;
        return this;
    }

    public Object getAroundRadius() {
        return this.aroundRadius;
    }

    @JsonIgnore
    public Query setAroundRadius(Object aroundRadius) {
        this.aroundRadius = aroundRadius;
        return this;
    }

    public Integer getAroundPrecision() {
        return this.aroundPrecision;
    }

    public Query setAroundPrecision(Integer aroundPrecision) {
        this.aroundPrecision = aroundPrecision;
        return this;
    }

    public Integer getMinimumAroundRadius() {
        return this.minimumAroundRadius;
    }

    public Query setMinimumAroundRadius(Integer minimumAroundRadius) {
        this.minimumAroundRadius = minimumAroundRadius;
        return this;
    }

    public List<String> getInsideBoundingBox() {
        return this.insideBoundingBox;
    }

    public Query setInsideBoundingBox(List<String> insideBoundingBox) {
        this.insideBoundingBox = insideBoundingBox;
        return this;
    }

    public List<String> getInsidePolygon() {
        return this.insidePolygon;
    }

    public Query setInsidePolygon(List<String> insidePolygon) {
        this.insidePolygon = insidePolygon;
        return this;
    }

    public List<String> getAttributesToHighlight() {
        return this.attributesToHighlight;
    }

    public Query setAttributesToHighlight(List<String> attributesToHighlight) {
        this.attributesToHighlight = attributesToHighlight;
        return this;
    }

    public List<String> getAttributesToSnippet() {
        return this.attributesToSnippet;
    }

    public Query setAttributesToSnippet(List<String> attributesToSnippet) {
        this.attributesToSnippet = attributesToSnippet;
        return this;
    }

    public String getHighlightPreTag() {
        return this.highlightPreTag;
    }

    public Query setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public String getHighlightPostTag() {
        return this.highlightPostTag;
    }

    public Query setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public String getSnippetEllipsisText() {
        return this.snippetEllipsisText;
    }

    public Query setSnippetEllipsisText(String snippetEllipsisText) {
        this.snippetEllipsisText = snippetEllipsisText;
        return this;
    }

    public Boolean getRestrictHighlightAndSnippetArrays() {
        return this.restrictHighlightAndSnippetArrays;
    }

    public Query setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
        this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
        return this;
    }

    public Long getPage() {
        return this.page;
    }

    @JsonSetter
    public Query setPage(Long page) {
        this.page = page;
        return this;
    }

    public Query setPage(Integer page) {
        return this.setPage(page.longValue());
    }

    public Long getHitsPerPage() {
        return this.hitsPerPage;
    }

    @JsonSetter
    public Query setHitsPerPage(Long hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return this;
    }

    public Query setHitsPerPage(Integer hitsPerPage) {
        return this.setHitsPerPage(hitsPerPage.longValue());
    }

    public Long getOffset() {
        return this.offset;
    }

    @JsonSetter
    public Query setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public Query setOffset(Integer offset) {
        return this.setOffset(offset.longValue());
    }

    public Long getLength() {
        return this.length;
    }

    @JsonSetter
    public Query setLength(Long length) {
        this.length = length;
        return this;
    }

    public Query setLength(Integer length) {
        return this.setLength(length.longValue());
    }

    public String getQueryType() {
        return this.queryType;
    }

    public Query setQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    public RemoveWordsType getRemoveWordsIfNoResults() {
        return this.removeWordsIfNoResults;
    }

    public Query setRemoveWordsIfNoResults(RemoveWordsType removeWordsIfNoResults) {
        this.removeWordsIfNoResults = removeWordsIfNoResults;
        return this;
    }

    public Boolean getAdvancedSyntax() {
        return this.advancedSyntax;
    }

    public Query setAdvancedSyntax(Boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return this;
    }

    public List<String> getOptionalWords() {
        return this.optionalWords;
    }

    public Query setOptionalWords(List<String> optionalWords) {
        this.optionalWords = optionalWords;
        return this;
    }

    public RemoveStopWords getRemoveStopWords() {
        return this.removeStopWords;
    }

    public Query setRemoveStopWords(RemoveStopWords removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this;
    }

    public List<String> getDisableExactOnAttributes() {
        return this.disableExactOnAttributes;
    }

    public Query setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
        this.disableExactOnAttributes = disableExactOnAttributes;
        return this;
    }

    public String getExactOnSingleWordQuery() {
        return this.exactOnSingleWordQuery;
    }

    public Query setExactOnSingleWordQuery(String exactOnSingleWordQuery) {
        this.exactOnSingleWordQuery = exactOnSingleWordQuery;
        return this;
    }

    public List<String> getAlternativesAsExact() {
        return this.alternativesAsExact;
    }

    public Query setAlternativesAsExact(List<String> alternativesAsExact) {
        this.alternativesAsExact = alternativesAsExact;
        return this;
    }

    public Integer getMinWordSizefor1Typo() {
        return this.minWordSizefor1Typo;
    }

    public Query setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
        this.minWordSizefor1Typo = minWordSizefor1Typo;
        return this;
    }

    public Integer getMinWordSizefor2Typos() {
        return this.minWordSizefor2Typos;
    }

    public Query setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
        this.minWordSizefor2Typos = minWordSizefor2Typos;
        return this;
    }

    public TypoTolerance getTypoTolerance() {
        return this.typoTolerance;
    }

    public Query setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return this;
    }

    public Boolean getAllowTyposOnNumericTokens() {
        return this.allowTyposOnNumericTokens;
    }

    public Query setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
        this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
        return this;
    }

    public IgnorePlurals getIgnorePlurals() {
        return this.ignorePlurals;
    }

    public Query setIgnorePlurals(IgnorePlurals ignorePlurals) {
        this.ignorePlurals = ignorePlurals;
        return this;
    }

    public List<String> getDisableTypoToleranceOnAttributes() {
        return this.disableTypoToleranceOnAttributes;
    }

    public Query setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
        this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
        return this;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public Query setUserToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    public Integer getValidUntil() {
        return this.validUntil;
    }

    public Query setValidUntil(Integer validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public List<String> getRestrictIndices() {
        return this.restrictIndices;
    }

    public Query setRestrictIndices(List<String> restrictIndices) {
        this.restrictIndices = restrictIndices;
        return this;
    }

    public String getRestrictSources() {
        return this.restrictSources;
    }

    public Query setRestrictSources(String restrictSources) {
        this.restrictSources = restrictSources;
        return this;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Query setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public Boolean getEnableRules() {
        return this.enableRules;
    }

    public Query setEnableRules(Boolean enableRules) {
        this.enableRules = enableRules;
        return this;
    }

    public List<String> getRuleContexts() {
        return this.ruleContexts;
    }

    public Query setRuleContexts(List<String> ruleContexts) {
        this.ruleContexts = ruleContexts;
        return this;
    }

    public Query setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getSortFacetValuesBy() {
        return this.sortFacetValuesBy;
    }

    public Query setSortFacetValuesBy(String sortFacetValuesBy) {
        this.sortFacetValuesBy = sortFacetValuesBy;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    @JsonAnySetter
    public Query setCustomParameters(Map<String, Object> customParameters) {
        this.customParameters = customParameters;
        return this;
    }

    public String toString() {
        return "Query{distinct=" + this.distinct + ", getRankingInfo=" + this.getRankingInfo + ", numericFilters=" + this.numericFilters + ", tagFilters=" + this.tagFilters + ", analytics=" + this.analytics + ", analyticsTags='" + this.analyticsTags + '\'' + ", synonyms=" + this.synonyms + ", replaceSynonymsInHighlight=" + this.replaceSynonymsInHighlight + ", minProximity=" + this.minProximity + ", responseFields=" + this.responseFields + ", maxFacetHits=" + this.maxFacetHits + ", percentileComputation=" + this.percentileComputation + ", attributesToRetrieve=" + this.attributesToRetrieve + ", restrictSearchableAttributes=" + this.restrictSearchableAttributes + ", filters='" + this.filters + '\'' + ", facets='" + this.facets + '\'' + ", maxValuesPerFacet=" + this.maxValuesPerFacet + ", facetFilters=" + this.facetFilters + ", facetingAfterDistinct=" + this.facetingAfterDistinct + ", sortFacetValuesBy" + this.sortFacetValuesBy + ", aroundLatLng='" + this.aroundLatLng + '\'' + ", aroundLatLngViaIP=" + this.aroundLatLngViaIP + ", aroundRadius=" + this.aroundRadius + ", aroundPrecision=" + this.aroundPrecision + ", minimumAroundRadius=" + this.minimumAroundRadius + ", insideBoundingBox=" + this.insideBoundingBox + ", insidePolygon=" + this.insidePolygon + ", attributesToHighlight=" + this.attributesToHighlight + ", attributesToSnippet=" + this.attributesToSnippet + ", highlightPreTag='" + this.highlightPreTag + '\'' + ", highlightPostTag='" + this.highlightPostTag + '\'' + ", snippetEllipsisText='" + this.snippetEllipsisText + '\'' + ", restrictHighlightAndSnippetArrays=" + this.restrictHighlightAndSnippetArrays + ", page=" + this.page + ", hitsPerPage=" + this.hitsPerPage + ", offset=" + this.offset + ", length=" + this.length + ", enableRules" + this.enableRules + ", ruleContexts" + this.ruleContexts + ", queryType='" + this.queryType + '\'' + ", removeWordsIfNoResults=" + (Object)((Object)this.removeWordsIfNoResults) + ", advancedSyntax=" + this.advancedSyntax + ", optionalWords=" + this.optionalWords + ", removeStopWords=" + this.removeStopWords + ", disableExactOnAttributes=" + this.disableExactOnAttributes + ", exactOnSingleWordQuery='" + this.exactOnSingleWordQuery + '\'' + ", alternativesAsExact=" + this.alternativesAsExact + ", query='" + this.query + '\'' + ", minWordSizefor1Typo=" + this.minWordSizefor1Typo + ", minWordSizefor2Typos=" + this.minWordSizefor2Typos + ", typoTolerance=" + this.typoTolerance + ", allowTyposOnNumericTokens=" + this.allowTyposOnNumericTokens + ", ignorePlurals=" + this.ignorePlurals + ", disableTypoToleranceOnAttributes=" + this.disableTypoToleranceOnAttributes + ", userToken='" + this.userToken + '\'' + ", validUntil=" + this.validUntil + ", restrictIndices=" + this.restrictIndices + ", restrictSources='" + this.restrictSources + '\'' + ", cursor='" + this.cursor + '\'' + ", customParameters=" + this.customParameters + '}';
    }

    public static enum RemoveWordsType {
        REMOVE_LAST_WORDS("LastWords"),
        REMOVE_FIRST_WORDS("FirstWords"),
        REMOVE_NONE("none"),
        REMOVE_ALLOPTIONAL("allOptional");

        private final String name;

        private RemoveWordsType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum QueryType {
        PREFIX_ALL("prefixAll"),
        PREFIX_LAST("prefixLast"),
        PREFIX_NONE("prefixNone");

        private final String name;

        private QueryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

