/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SyncBaseIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.Task;
import javax.annotation.Nonnull;

public interface SyncSettings<T>
extends SyncBaseIndex<T> {
    default public IndexSettings getSettings() throws AlgoliaException {
        return this.getSettings(RequestOptions.empty);
    }

    default public IndexSettings getSettings(@Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getSettings(this.getName(), requestOptions);
    }

    default public Task setSettings(@Nonnull IndexSettings settings) throws AlgoliaException {
        return this.setSettings(settings, RequestOptions.empty);
    }

    default public Task setSettings(@Nonnull IndexSettings settings, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.setSettings(settings, false, requestOptions);
    }

    default public Task setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas) throws AlgoliaException {
        return this.setSettings(settings, forwardToReplicas, RequestOptions.empty);
    }

    default public Task setSettings(@Nonnull IndexSettings settings, @Nonnull Boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().setSettings(this.getName(), settings, forwardToReplicas, requestOptions);
    }
}

