/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseSyncIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskIndexing;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

interface Objects<T>
extends BaseSyncIndex<T> {
    default public TaskIndexing addObject(@Nonnull T object) throws AlgoliaException {
        return this.addObject(object, RequestOptions.empty);
    }

    default public TaskIndexing addObject(@Nonnull T object, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addObject(this.getName(), object, requestOptions);
    }

    default public TaskIndexing addObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.addObject(objectID, object, RequestOptions.empty);
    }

    default public TaskIndexing addObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addObject(this.getName(), objectID, object, requestOptions);
    }

    default public TaskSingleIndex addObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.addObjects(objects, RequestOptions.empty);
    }

    default public TaskSingleIndex addObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().addObjects(this.getName(), objects, requestOptions);
    }

    default public Optional<T> getObject(@Nonnull String objectID) throws AlgoliaException {
        return this.getObject(objectID, RequestOptions.empty);
    }

    default public Optional<T> getObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getObject(this.getName(), objectID, this.getKlass(), requestOptions);
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.getObjects(objectIDs, RequestOptions.empty);
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getObjects(this.getName(), objectIDs, this.getKlass(), requestOptions);
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) throws AlgoliaException {
        return this.getObjects(objectIDs, attributesToRetrieve, RequestOptions.empty);
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().getObjects(this.getName(), objectIDs, attributesToRetrieve, this.getKlass(), requestOptions);
    }

    default public Task saveObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.saveObject(objectID, object, RequestOptions.empty);
    }

    default public Task saveObject(@Nonnull String objectID, @Nonnull T object, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().saveObject(this.getName(), objectID, object, requestOptions);
    }

    default public TaskSingleIndex saveObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.saveObjects(objects, RequestOptions.empty);
    }

    default public TaskSingleIndex saveObjects(@Nonnull List<T> objects, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().saveObjects(this.getName(), objects, requestOptions);
    }

    default public Task deleteObject(@Nonnull String objectID) throws AlgoliaException {
        return this.deleteObject(objectID, RequestOptions.empty);
    }

    default public Task deleteObject(@Nonnull String objectID, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteObject(this.getName(), objectID, requestOptions);
    }

    default public TaskSingleIndex deleteObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.deleteObjects(objectIDs, RequestOptions.empty);
    }

    default public TaskSingleIndex deleteObjects(@Nonnull List<String> objectIDs, @Nonnull RequestOptions requestOptions) throws AlgoliaException {
        return this.getApiClient().deleteObjects(this.getName(), objectIDs, requestOptions);
    }
}

