/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseAsyncIndex;
import com.algolia.search.inputs.query_rules.Rule;
import com.algolia.search.objects.RequestOptions;
import com.algolia.search.objects.RuleQuery;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.responses.SearchRuleResult;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

interface AsyncRules<T>
extends BaseAsyncIndex<T> {
    default public CompletableFuture<AsyncTask> saveRule(@Nonnull String ruleID, @Nonnull Rule rule) {
        return this.saveRule(ruleID, rule, false);
    }

    default public CompletableFuture<AsyncTask> saveRule(@Nonnull String ruleID, @Nonnull Rule rule, @Nonnull RequestOptions requestOptions) {
        return this.saveRule(ruleID, rule, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> saveRule(@Nonnull String ruleID, @Nonnull Rule rule, boolean forwardToReplicas) {
        return this.saveRule(ruleID, rule, forwardToReplicas, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> saveRule(@Nonnull String ruleID, @Nonnull Rule rule, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().saveRule(this.getName(), ruleID, rule, forwardToReplicas, requestOptions);
    }

    default public CompletableFuture<Optional<Rule>> getRule(@Nonnull String ruleID) {
        return this.getRule(ruleID, RequestOptions.empty);
    }

    default public CompletableFuture<Optional<Rule>> getRule(@Nonnull String ruleID, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().getRule(this.getName(), ruleID, requestOptions);
    }

    default public CompletableFuture<AsyncTask> deleteRule(@Nonnull String ruleID) {
        return this.deleteRule(ruleID, false);
    }

    default public CompletableFuture<AsyncTask> deleteRule(@Nonnull String ruleID, @Nonnull RequestOptions requestOptions) {
        return this.deleteRule(ruleID, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> deleteRule(@Nonnull String ruleID, boolean forwardToReplicas) {
        return this.deleteRule(ruleID, forwardToReplicas, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> deleteRule(@Nonnull String ruleID, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().deleteRule(this.getName(), ruleID, forwardToReplicas, requestOptions);
    }

    default public CompletableFuture<AsyncTask> clearRules() {
        return this.clearRules(false);
    }

    default public CompletableFuture<AsyncTask> clearRules(@Nonnull RequestOptions requestOptions) {
        return this.clearRules(false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> clearRules(boolean forwardToReplicas) {
        return this.clearRules(forwardToReplicas, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> clearRules(boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().clearRules(this.getName(), forwardToReplicas, requestOptions);
    }

    default public CompletableFuture<SearchRuleResult> searchRules(@Nonnull RuleQuery query) {
        return this.searchRules(query, RequestOptions.empty);
    }

    default public CompletableFuture<SearchRuleResult> searchRules(@Nonnull RuleQuery query, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().searchRules(this.getName(), query, requestOptions);
    }

    default public CompletableFuture<AsyncTask> batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas, boolean clearExistingRules) {
        return this.batchRules(rules, forwardToReplicas, clearExistingRules, RequestOptions.empty);
    }

    default public CompletableFuture<AsyncTask> batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas, boolean clearExistingRules, @Nonnull RequestOptions requestOptions) {
        return this.getApiClient().batchRules(this.getName(), rules, forwardToReplicas, clearExistingRules, requestOptions);
    }

    default public CompletableFuture<AsyncTask> batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas) {
        return this.batchRules(rules, forwardToReplicas, false);
    }

    default public CompletableFuture<AsyncTask> batchRules(@Nonnull List<Rule> rules, boolean forwardToReplicas, @Nonnull RequestOptions requestOptions) {
        return this.batchRules(rules, forwardToReplicas, false, requestOptions);
    }

    default public CompletableFuture<AsyncTask> batchRules(@Nonnull List<Rule> rules) {
        return this.batchRules(rules, false, false);
    }

    default public CompletableFuture<AsyncTask> batchRules(@Nonnull List<Rule> rules, @Nonnull RequestOptions requestOptions) {
        return this.batchRules(rules, false, false, requestOptions);
    }
}

