/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.http;

import com.algolia.search.Utils;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.exceptions.AlgoliaHttpException;
import com.algolia.search.exceptions.AlgoliaHttpRetriesException;
import com.algolia.search.exceptions.AlgoliaIOException;
import com.algolia.search.http.AlgoliaHttpRequest;
import com.algolia.search.http.AlgoliaHttpResponse;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.HostStatus;
import com.algolia.search.responses.AlgoliaError;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlgoliaHttpClient {
    protected final Logger logger = LoggerFactory.getLogger((String)"algoliasearch");
    @VisibleForTesting
    Map<String, HostStatus> hostStatuses = new ConcurrentHashMap<String, HostStatus>();

    protected Instant now() {
        return Instant.now();
    }

    protected abstract AlgoliaHttpResponse request(@Nonnull AlgoliaHttpRequest var1) throws IOException;

    protected abstract ObjectMapper getObjectMapper();

    public abstract List<String> getQueryHosts();

    public abstract List<String> getBuildHosts();

    public abstract int getHostDownTimeout();

    private HostStatus emptyHostStatus() {
        return new HostStatus(this.getHostDownTimeout(), true, this.now());
    }

    private HostStatus downHostStatus() {
        return new HostStatus(this.getHostDownTimeout(), false, this.now());
    }

    private HostStatus upHostStatus() {
        return new HostStatus(this.getHostDownTimeout(), true, this.now());
    }

    private HostStatus getStatus(String host) {
        return this.hostStatuses.getOrDefault(host, this.emptyHostStatus());
    }

    private List<String> queryHostsThatAreUp() {
        return this.hostsThatAreUp(this.getQueryHosts());
    }

    private List<String> buildHostsThatAreUp() {
        return this.hostsThatAreUp(this.getBuildHosts());
    }

    private List<String> hostsThatAreUp(List<String> hosts) {
        return hosts.stream().filter(s -> this.getStatus((String)s).isUpOrCouldBeRetried(this.now())).collect(Collectors.toList());
    }

    private void markHostAsDown(String host) {
        this.logger.debug("Marking {} as `down`", (Object)host);
        this.hostStatuses.put(host, this.downHostStatus());
    }

    private void markHostAsUpdatedAndUp(String host) {
        this.logger.debug("Marking {} as `up`", (Object)host);
        this.hostStatuses.put(host, this.upHostStatus());
    }

    public <T> T requestWithRetry(@Nonnull AlgoliaRequest<T> request) throws AlgoliaException {
        List<String> hosts = request.isSearch() ? this.queryHostsThatAreUp() : this.buildHostsThatAreUp();
        String content = null;
        if (request.hasData()) {
            try {
                content = this.getObjectMapper().writeValueAsString(request.getData());
            }
            catch (IOException e) {
                throw new AlgoliaException("can not serialize request body", e);
            }
        }
        AlgoliaHttpResponse response = null;
        ArrayList<AlgoliaIOException> ioExceptionList = new ArrayList<AlgoliaIOException>(4);
        for (String host : hosts) {
            this.logger.debug("Trying {}", (Object)host);
            this.logger.debug("Querying {}", (Object)request.toString(host));
            try {
                response = this.request(new AlgoliaHttpRequest(host, content, request));
            }
            catch (IOException e) {
                this.logger.debug("Failing to query {}", (Object)host, (Object)e);
                this.markHostAsDown(host);
                ioExceptionList.add(new AlgoliaIOException(host, e));
                continue;
            }
            this.markHostAsUpdatedAndUp(host);
            int code2 = response.getStatusCode() / 100;
            if (code2 != 2 && code2 != 4) continue;
            this.logger.debug("Got HTTP code {}, no retry", (Object)response.getStatusCode());
            break;
        }
        if (response == null) {
            this.logger.debug("All retries failed");
            throw new AlgoliaHttpRetriesException("All retries failed", ioExceptionList);
        }
        try {
            int code = response.getStatusCode();
            if (code / 100 == 4) {
                String message = Utils.parseAs(this.getObjectMapper(), response.getBody(), AlgoliaError.class).getMessage();
                this.logger.debug("Got HTTP code {}", (Object)code);
                switch (code) {
                    case 400: {
                        throw new AlgoliaHttpException(code, message.length() > 0 ? message : "Bad build request");
                    }
                    case 403: {
                        throw new AlgoliaHttpException(code, message.length() > 0 ? message : "Invalid Application-ID or API-Key");
                    }
                    case 404: {
                        T code2 = null;
                        return code2;
                    }
                }
                throw new AlgoliaHttpException(code, message.length() > 0 ? message : "Error");
            }
            Object t = Utils.parseAs(this.getObjectMapper(), response.getBody(), request.getJavaType(this.getObjectMapper().getTypeFactory()));
            return t;
        }
        catch (IOException e) {
            this.logger.debug("Error while deserialization", (Throwable)e);
            throw new AlgoliaException("Error while deserialization the response", e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                this.logger.debug("Can not close underlying response", (Throwable)e);
                throw new AlgoliaException("Can not close underlying response", e);
            }
        }
    }

    public abstract void close() throws AlgoliaException;
}

