/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.objects;

import com.algolia.search.objects.Distinct;
import com.algolia.search.objects.IgnorePlurals;
import com.algolia.search.objects.RemoveStopWords;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Query {
    private Distinct distinct;
    private Boolean getRankingInfo;
    private List<String> numericFilters;
    private List<String> tagFilters;
    private Boolean analytics;
    private String analyticsTags;
    private Boolean synonyms;
    private Boolean replaceSynonymsInHighlight;
    private Integer minProximity;
    private List<String> responseFields;
    private Integer maxFacetHits;
    private Boolean percentileComputation;
    private List<String> attributesToRetrieve;
    private List<String> restrictSearchableAttributes;
    private String filters;
    private String facets;
    private Integer maxValuesPerFacet;
    private List<String> facetFilters;
    private Boolean facetingAfterDistinct;
    private String aroundLatLng;
    private Boolean aroundLatLngViaIP;
    private Object aroundRadius;
    private Integer aroundPrecision;
    private Integer minimumAroundRadius;
    private List<String> insideBoundingBox;
    private List<String> insidePolygon;
    private List<String> attributesToHighlight;
    private List<String> attributesToSnippet;
    private String highlightPreTag;
    private String highlightPostTag;
    private String snippetEllipsisText;
    private Boolean restrictHighlightAndSnippetArrays;
    private Integer page;
    private Integer hitsPerPage;
    private Integer offset;
    private Integer length;
    private String queryType;
    private RemoveWordsType removeWordsIfNoResults;
    private Boolean advancedSyntax;
    private List<String> optionalWords;
    private RemoveStopWords removeStopWords;
    private List<String> disableExactOnAttributes;
    private String exactOnSingleWordQuery;
    private List<String> alternativesAsExact;
    private String query;
    private Integer minWordSizefor1Typo;
    private Integer minWordSizefor2Typos;
    private TypoTolerance typoTolerance;
    private Boolean allowTyposOnNumericTokens;
    private IgnorePlurals ignorePlurals;
    private List<String> disableTypoToleranceOnAttributes;
    private String userToken;
    private Integer validUntil;
    private List<String> restrictIndices;
    private String restrictSources;
    private String cursor;
    private Map<String, String> customParameters = new HashMap<String, String>();

    public Query() {
    }

    public Query(String query) {
        this.query = query;
    }

    public Map<String, String> toQueryParam() {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder = this.add(builder, "distinct", this.distinct);
        builder = this.add(builder, "getRankingInfo", this.getRankingInfo);
        builder = this.add(builder, "numericFilters", this.numericFilters);
        builder = this.add(builder, "tagFilters", this.tagFilters);
        builder = this.add(builder, "analytics", this.analytics);
        builder = this.add(builder, "analyticsTags", this.analyticsTags);
        builder = this.add(builder, "synonyms", this.synonyms);
        builder = this.add(builder, "replaceSynonymsInHighlight", this.replaceSynonymsInHighlight);
        builder = this.add(builder, "minProximity", this.minProximity);
        builder = this.add(builder, "responseFields", this.responseFields);
        builder = this.add(builder, "maxFacetHits", this.maxFacetHits);
        builder = this.add(builder, "percentileComputation", this.percentileComputation);
        builder = this.add(builder, "attributesToRetrieve", this.attributesToRetrieve);
        builder = this.add(builder, "restrictSearchableAttributes", this.restrictSearchableAttributes);
        builder = this.add(builder, "filters", this.filters);
        builder = this.add(builder, "facets", this.facets);
        builder = this.add(builder, "maxValuesPerFacet", this.maxValuesPerFacet);
        builder = this.add(builder, "facetFilters", this.facetFilters);
        builder = this.add(builder, "facetingAfterDistinct", this.facetingAfterDistinct);
        builder = this.add(builder, "aroundLatLng", this.aroundLatLng);
        builder = this.add(builder, "aroundLatLngViaIP", this.aroundLatLngViaIP);
        builder = this.add(builder, "aroundRadius", this.aroundRadius);
        builder = this.add(builder, "aroundPrecision", this.aroundPrecision);
        builder = this.add(builder, "minimumAroundRadius", this.minimumAroundRadius);
        builder = this.add(builder, "insideBoundingBox", this.insideBoundingBox);
        builder = this.add(builder, "insidePolygon", this.insidePolygon);
        builder = this.add(builder, "attributesToHighlight", this.attributesToHighlight);
        builder = this.add(builder, "attributesToSnippet", this.attributesToSnippet);
        builder = this.add(builder, "highlightPreTag", this.highlightPreTag);
        builder = this.add(builder, "highlightPostTag", this.highlightPostTag);
        builder = this.add(builder, "snippetEllipsisText", this.snippetEllipsisText);
        builder = this.add(builder, "restrictHighlightAndSnippetArrays", this.restrictHighlightAndSnippetArrays);
        builder = this.add(builder, "page", this.page);
        builder = this.add(builder, "hitsPerPage", this.hitsPerPage);
        builder = this.add(builder, "offset", this.offset);
        builder = this.add(builder, "length", this.length);
        builder = this.add(builder, "queryType", this.queryType);
        builder = this.add(builder, "removeWordsIfNoResults", this.removeWordsIfNoResults);
        builder = this.add(builder, "advancedSyntax", this.advancedSyntax);
        builder = this.add(builder, "optionalWords", this.optionalWords);
        builder = this.add(builder, "removeStopWords", this.removeStopWords);
        builder = this.add(builder, "disableExactOnAttributes", this.disableExactOnAttributes);
        builder = this.add(builder, "exactOnSingleWordQuery", this.exactOnSingleWordQuery);
        builder = this.add(builder, "alternativesAsExact", this.alternativesAsExact);
        builder = this.add(builder, "query", this.query);
        builder = this.add(builder, "minWordSizefor1Typo", this.minWordSizefor1Typo);
        builder = this.add(builder, "minWordSizefor2Typos", this.minWordSizefor2Typos);
        builder = this.add(builder, "typoTolerance", this.typoTolerance);
        builder = this.add(builder, "allowTyposOnNumericTokens", this.allowTyposOnNumericTokens);
        builder = this.add(builder, "ignorePlurals", this.ignorePlurals);
        builder = this.add(builder, "disableTypoToleranceOnAttributes", this.disableTypoToleranceOnAttributes);
        builder = this.add(builder, "userToken", this.userToken);
        builder = this.add(builder, "validUntil", this.validUntil);
        builder = this.add(builder, "restrictIndices", this.restrictIndices);
        builder = this.add(builder, "restrictSources", this.restrictSources);
        builder = this.add(builder, "cursor", this.cursor);
        for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
            builder = this.add(builder, entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Object value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Enum<?> value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, String value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value);
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Boolean value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, Integer value) {
        if (value == null) {
            return builder;
        }
        return builder.put((Object)name, (Object)value.toString());
    }

    private ImmutableMap.Builder<String, String> add(ImmutableMap.Builder<String, String> builder, String name, List<String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return builder;
        }
        return builder.put((Object)name, (Object)String.join((CharSequence)",", attributes));
    }

    public String toParam() {
        StringBuilder builder = new StringBuilder();
        boolean firstOne = true;
        for (Map.Entry<String, String> entry : this.toQueryParam().entrySet()) {
            try {
                if (!firstOne) {
                    builder = builder.append("&");
                }
                builder = builder.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            firstOne = false;
        }
        return builder.toString();
    }

    public Query setAroundRadius(Integer aroundRadius) {
        this.aroundRadius = aroundRadius;
        return this;
    }

    public Query setAroundRadiusAll() {
        this.aroundRadius = "all";
        return this;
    }

    public Query addCustomParameter(String key, String value) {
        this.customParameters.put(key, value);
        return this;
    }

    public Query setDistinct(Distinct distinct) {
        this.distinct = distinct;
        return this;
    }

    public Query setGetRankingInfo(Boolean getRankingInfo) {
        this.getRankingInfo = getRankingInfo;
        return this;
    }

    public Query setNumericFilters(List<String> numericFilters) {
        this.numericFilters = numericFilters;
        return this;
    }

    public Query setTagFilters(List<String> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public Query setAnalytics(Boolean analytics) {
        this.analytics = analytics;
        return this;
    }

    public Query setAnalyticsTags(String analyticsTags) {
        this.analyticsTags = analyticsTags;
        return this;
    }

    public Query setSynonyms(Boolean synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public Query setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
        this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
        return this;
    }

    public Query setMinProximity(Integer minProximity) {
        this.minProximity = minProximity;
        return this;
    }

    public Query setResponseFields(List<String> responseFields) {
        this.responseFields = responseFields;
        return this;
    }

    public Query setMaxFacetHits(Integer maxFacetHits) {
        this.maxFacetHits = maxFacetHits;
        return this;
    }

    public Query setAttributesToRetrieve(List<String> attributesToRetrieve) {
        this.attributesToRetrieve = attributesToRetrieve;
        return this;
    }

    public Query setRestrictSearchableAttributes(List<String> restrictSearchableAttributes) {
        this.restrictSearchableAttributes = restrictSearchableAttributes;
        return this;
    }

    public Query setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public Query setFacets(String facets) {
        this.facets = facets;
        return this;
    }

    public Query setMaxValuesPerFacet(Integer maxValuesPerFacet) {
        this.maxValuesPerFacet = maxValuesPerFacet;
        return this;
    }

    public Query setFacetFilters(List<String> facetFilters) {
        this.facetFilters = facetFilters;
        return this;
    }

    public Query setFacetingAfterDistinct(Boolean facetingAfterDistinct) {
        this.facetingAfterDistinct = facetingAfterDistinct;
        return this;
    }

    public Query setAroundLatLng(String aroundLatLng) {
        this.aroundLatLng = aroundLatLng;
        return this;
    }

    public Query setAroundLatLngViaIP(Boolean aroundLatLngViaIP) {
        this.aroundLatLngViaIP = aroundLatLngViaIP;
        return this;
    }

    public Query setAroundRadius(Object aroundRadius) {
        this.aroundRadius = aroundRadius;
        return this;
    }

    public Query setAroundPrecision(Integer aroundPrecision) {
        this.aroundPrecision = aroundPrecision;
        return this;
    }

    public Query setMinimumAroundRadius(Integer minimumAroundRadius) {
        this.minimumAroundRadius = minimumAroundRadius;
        return this;
    }

    public Query setInsideBoundingBox(List<String> insideBoundingBox) {
        this.insideBoundingBox = insideBoundingBox;
        return this;
    }

    public Query setInsidePolygon(List<String> insidePolygon) {
        this.insidePolygon = insidePolygon;
        return this;
    }

    public Query setAttributesToHighlight(List<String> attributesToHighlight) {
        this.attributesToHighlight = attributesToHighlight;
        return this;
    }

    public Query setAttributesToSnippet(List<String> attributesToSnippet) {
        this.attributesToSnippet = attributesToSnippet;
        return this;
    }

    public Query setHighlightPreTag(String highlightPreTag) {
        this.highlightPreTag = highlightPreTag;
        return this;
    }

    public Query setHighlightPostTag(String highlightPostTag) {
        this.highlightPostTag = highlightPostTag;
        return this;
    }

    public Query setSnippetEllipsisText(String snippetEllipsisText) {
        this.snippetEllipsisText = snippetEllipsisText;
        return this;
    }

    public Query setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
        this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
        return this;
    }

    public Query setPage(Integer page) {
        this.page = page;
        return this;
    }

    public Query setHitsPerPage(Integer hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return this;
    }

    public Query setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Query setLength(Integer length) {
        this.length = length;
        return this;
    }

    public Query setQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    public Query setRemoveWordsIfNoResults(RemoveWordsType removeWordsIfNoResults) {
        this.removeWordsIfNoResults = removeWordsIfNoResults;
        return this;
    }

    public Query setAdvancedSyntax(Boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return this;
    }

    public Query setOptionalWords(List<String> optionalWords) {
        this.optionalWords = optionalWords;
        return this;
    }

    public Query setRemoveStopWords(RemoveStopWords removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this;
    }

    public Query setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
        this.disableExactOnAttributes = disableExactOnAttributes;
        return this;
    }

    public Query setExactOnSingleWordQuery(String exactOnSingleWordQuery) {
        this.exactOnSingleWordQuery = exactOnSingleWordQuery;
        return this;
    }

    public Query setAlternativesAsExact(List<String> alternativesAsExact) {
        this.alternativesAsExact = alternativesAsExact;
        return this;
    }

    public Query setQuery(String query) {
        this.query = query;
        return this;
    }

    public Query setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
        this.minWordSizefor1Typo = minWordSizefor1Typo;
        return this;
    }

    public Query setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
        this.minWordSizefor2Typos = minWordSizefor2Typos;
        return this;
    }

    public Query setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return this;
    }

    public Query setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
        this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
        return this;
    }

    public Query setIgnorePlurals(IgnorePlurals ignorePlurals) {
        this.ignorePlurals = ignorePlurals;
        return this;
    }

    public Query setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
        this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
        return this;
    }

    public Query setUserToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    public Query setValidUntil(Integer validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public Query setRestrictIndices(List<String> restrictIndices) {
        this.restrictIndices = restrictIndices;
        return this;
    }

    public Query setRestrictSources(String restrictSources) {
        this.restrictSources = restrictSources;
        return this;
    }

    public Query setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    public Query setPercentileComputation(Boolean percentileComputation) {
        this.percentileComputation = percentileComputation;
        return this;
    }

    public static enum TypoTolerance {
        TYPO_TRUE("true"),
        TYPO_FALSE("false"),
        TYPO_MIN("min"),
        TYPO_STRICT("strict");

        private final String name;

        private TypoTolerance(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum RemoveWordsType {
        REMOVE_LAST_WORDS("LastWords"),
        REMOVE_FIRST_WORDS("FirstWords"),
        REMOVE_NONE("none"),
        REMOVE_ALLOPTIONAL("allOptional");

        private final String name;

        private RemoveWordsType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum QueryType {
        PREFIX_ALL("prefixAll"),
        PREFIX_LAST("prefixLast"),
        PREFIX_NONE("prefixNone");

        private final String name;

        private QueryType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

