/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseSyncIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.responses.SearchSynonymResult;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

interface Synonyms<T>
extends BaseSyncIndex<T> {
    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, false);
    }

    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas) throws AlgoliaException {
        return this.saveSynonym(synonymID, content, forwardToReplicas, false);
    }

    default public Task saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        return this.getApiClient().saveSynonym(this.getName(), synonymID, content, forwardToReplicas, replaceExistingSynonyms);
    }

    default public Optional<AbstractSynonym> getSynonym(@Nonnull String synonymID) throws AlgoliaException {
        return this.getApiClient().getSynonym(this.getName(), synonymID);
    }

    default public Task deleteSynonym(@Nonnull String synonymID) throws AlgoliaException {
        return this.deleteSynonym(synonymID, false);
    }

    default public Task deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas) throws AlgoliaException {
        return this.getApiClient().deleteSynonym(this.getName(), synonymID, forwardToReplicas);
    }

    default public Task clearSynonyms() throws AlgoliaException {
        return this.clearSynonyms(false);
    }

    default public Task clearSynonyms(boolean forwardToReplicas) throws AlgoliaException {
        return this.getApiClient().clearSynonyms(this.getName(), forwardToReplicas);
    }

    default public SearchSynonymResult searchSynonyms(@Nonnull SynonymQuery query) throws AlgoliaException {
        return this.getApiClient().searchSynonyms(this.getName(), query);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        return this.getApiClient().batchSynonyms(this.getName(), synonyms, forwardToReplicas, replaceExistingSynonyms);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchSynonyms(synonyms, forwardToReplicas, false);
    }

    default public Task batchSynonyms(@Nonnull List<AbstractSynonym> synonyms) throws AlgoliaException {
        return this.batchSynonyms(synonyms, false, false);
    }
}

