/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseSyncIndex;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskIndexing;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

interface Objects<T>
extends BaseSyncIndex<T> {
    default public TaskIndexing addObject(@Nonnull T object) throws AlgoliaException {
        return this.getApiClient().addObject(this.getName(), object);
    }

    default public TaskIndexing addObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.getApiClient().addObject(this.getName(), objectID, object);
    }

    default public TaskSingleIndex addObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.getApiClient().addObjects(this.getName(), objects);
    }

    default public Optional<T> getObject(@Nonnull String objectID) throws AlgoliaException {
        return this.getApiClient().getObject(this.getName(), objectID, this.getKlass());
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.getApiClient().getObjects(this.getName(), objectIDs, this.getKlass());
    }

    default public List<T> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) throws AlgoliaException {
        return this.getApiClient().getObjects(this.getName(), objectIDs, attributesToRetrieve, this.getKlass());
    }

    default public Task saveObject(@Nonnull String objectID, @Nonnull T object) throws AlgoliaException {
        return this.getApiClient().saveObject(this.getName(), objectID, object);
    }

    default public TaskSingleIndex saveObjects(@Nonnull List<T> objects) throws AlgoliaException {
        return this.getApiClient().saveObjects(this.getName(), objects);
    }

    default public Task deleteObject(@Nonnull String objectID) throws AlgoliaException {
        return this.getApiClient().deleteObject(this.getName(), objectID);
    }

    default public TaskSingleIndex deleteObjects(@Nonnull List<String> objectIDs) throws AlgoliaException {
        return this.getApiClient().deleteObjects(this.getName(), objectIDs);
    }
}

