/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClient;
import com.algolia.search.Browse;
import com.algolia.search.DeleteByQuery;
import com.algolia.search.IndexCRUD;
import com.algolia.search.Key;
import com.algolia.search.Objects;
import com.algolia.search.PartialUpdate;
import com.algolia.search.SearchForFacet;
import com.algolia.search.Settings;
import com.algolia.search.Synonyms;
import com.algolia.search.Tasks;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import com.algolia.search.responses.SearchResult;
import java.util.List;
import javax.annotation.Nonnull;

public class Index<T>
implements DeleteByQuery<T>,
Browse<T>,
Synonyms<T>,
PartialUpdate<T>,
SearchForFacet<T>,
Key<T>,
Settings<T>,
Objects<T>,
Tasks<T>,
IndexCRUD<T> {
    private final String name;
    private final Class<T> klass;
    private final APIClient client;

    Index(String name, Class<T> klass, APIClient client) {
        this.name = name;
        this.klass = klass;
        this.client = client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    @Override
    public APIClient getApiClient() {
        return this.client;
    }

    public SearchResult<T> search(@Nonnull Query query) throws AlgoliaException {
        return this.client.search(this.name, query, this.klass);
    }

    public TaskSingleIndex batch(@Nonnull List<BatchOperation> operations) throws AlgoliaException {
        return this.client.batch(this.name, operations);
    }

    public static class Attributes {
        private String name;
        private String createdAt;
        private String updatedAt;
        private Integer entries;
        private Integer dataSize;
        private Integer fileSize;
        private Integer lastBuildTimeS;
        private Integer numberOfPendingTask;
        private Boolean pendingTask;

        public String getName() {
            return this.name;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public Integer getEntries() {
            return this.entries;
        }

        public Integer getDataSize() {
            return this.dataSize;
        }

        public Integer getFileSize() {
            return this.fileSize;
        }

        public Integer getLastBuildTimeS() {
            return this.lastBuildTimeS;
        }

        public Integer getNumberOfPendingTask() {
            return this.numberOfPendingTask;
        }

        public Boolean getPendingTask() {
            return this.pendingTask;
        }
    }
}

