/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseAsyncIndex;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.responses.SearchSynonymResult;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

interface AsyncSynonyms<T>
extends BaseAsyncIndex<T> {
    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content) {
        return this.saveSynonym(synonymID, content, false);
    }

    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas) {
        return this.saveSynonym(synonymID, content, forwardToReplicas, false);
    }

    default public CompletableFuture<AsyncTask> saveSynonym(@Nonnull String synonymID, @Nonnull AbstractSynonym content, boolean forwardToReplicas, boolean replaceExistingSynonyms) {
        return this.getApiClient().saveSynonym(this.getName(), synonymID, content, forwardToReplicas, replaceExistingSynonyms);
    }

    default public CompletableFuture<Optional<AbstractSynonym>> getSynonym(@Nonnull String synonymID) {
        return this.getApiClient().getSynonym(this.getName(), synonymID);
    }

    default public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID) {
        return this.deleteSynonym(synonymID, false);
    }

    default public CompletableFuture<AsyncTask> deleteSynonym(@Nonnull String synonymID, boolean forwardToReplicas) {
        return this.getApiClient().deleteSynonym(this.getName(), synonymID, forwardToReplicas);
    }

    default public CompletableFuture<AsyncTask> clearSynonyms() {
        return this.clearSynonyms(false);
    }

    default public CompletableFuture<AsyncTask> clearSynonyms(boolean forwardToReplicas) {
        return this.getApiClient().clearSynonyms(this.getName(), forwardToReplicas);
    }

    default public CompletableFuture<SearchSynonymResult> searchSynonyms(@Nonnull SynonymQuery query) {
        return this.getApiClient().searchSynonyms(this.getName(), query);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas, boolean replaceExistingSynonyms) {
        return this.getApiClient().batchSynonyms(this.getName(), synonyms, forwardToReplicas, replaceExistingSynonyms);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms, boolean forwardToReplicas) {
        return this.batchSynonyms(synonyms, forwardToReplicas, false);
    }

    default public CompletableFuture<AsyncTask> batchSynonyms(@Nonnull List<AbstractSynonym> synonyms) {
        return this.batchSynonyms(synonyms, false, false);
    }
}

