/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.BaseAsyncIndex;
import com.algolia.search.objects.tasks.async.AsyncTask;
import com.algolia.search.objects.tasks.async.AsyncTaskIndexing;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

interface AsyncObjects<T>
extends BaseAsyncIndex<T> {
    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull T object) {
        return this.getApiClient().addObject(this.getName(), object);
    }

    default public CompletableFuture<AsyncTaskIndexing> addObject(@Nonnull String objectID, @Nonnull T object) {
        return this.getApiClient().addObject(this.getName(), objectID, object);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> addObjects(@Nonnull List<T> objects) {
        return this.getApiClient().addObjects(this.getName(), objects);
    }

    default public CompletableFuture<Optional<T>> getObject(@Nonnull String objectID) {
        return this.getApiClient().getObject(this.getName(), objectID, this.getKlass());
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs) {
        return this.getApiClient().getObjects(this.getName(), objectIDs, this.getKlass());
    }

    default public CompletableFuture<List<T>> getObjects(@Nonnull List<String> objectIDs, @Nonnull List<String> attributesToRetrieve) {
        return this.getApiClient().getObjects(this.getName(), objectIDs, attributesToRetrieve, this.getKlass());
    }

    default public CompletableFuture<AsyncTask> saveObject(@Nonnull String objectID, @Nonnull T object) {
        return this.getApiClient().saveObject(this.getName(), objectID, object);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> saveObjects(@Nonnull List<T> objects) {
        return this.getApiClient().saveObjects(this.getName(), objects);
    }

    default public CompletableFuture<AsyncTask> deleteObject(@Nonnull String objectID) {
        return this.getApiClient().deleteObject(this.getName(), objectID);
    }

    default public CompletableFuture<AsyncTaskSingleIndex> deleteObjects(@Nonnull List<String> objectIDs) {
        return this.getApiClient().deleteObjects(this.getName(), objectIDs);
    }
}

