/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.AsyncAPIClient;
import com.algolia.search.AsyncIndexCRUD;
import com.algolia.search.AsyncKey;
import com.algolia.search.AsyncObjects;
import com.algolia.search.AsyncPartialUpdate;
import com.algolia.search.AsyncSearchForFacet;
import com.algolia.search.AsyncSettings;
import com.algolia.search.AsyncSynonyms;
import com.algolia.search.AsyncTasks;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.tasks.async.AsyncTaskSingleIndex;
import com.algolia.search.responses.SearchResult;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AsyncIndex<T>
implements AsyncIndexCRUD<T>,
AsyncTasks<T>,
AsyncObjects<T>,
AsyncSettings<T>,
AsyncKey<T>,
AsyncSearchForFacet<T>,
AsyncPartialUpdate<T>,
AsyncSynonyms<T> {
    private final String name;
    private final Class<T> klass;
    private final AsyncAPIClient client;

    AsyncIndex(String name, Class<T> klass, AsyncAPIClient client) {
        this.name = name;
        this.klass = klass;
        this.client = client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    @Override
    public AsyncAPIClient getApiClient() {
        return this.client;
    }

    public CompletableFuture<SearchResult<T>> search(@Nonnull Query query) {
        return this.client.search(this.name, query, this.klass);
    }

    public CompletableFuture<AsyncTaskSingleIndex> batch(@Nonnull List<BatchOperation> operations) {
        return this.client.batch(this.name, operations);
    }
}

