/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.indexing;

import com.algolia.search.com.fasterxml.jackson.core.JsonParser;
import com.algolia.search.com.fasterxml.jackson.core.JsonToken;
import com.algolia.search.com.fasterxml.jackson.databind.DeserializationContext;
import com.algolia.search.com.fasterxml.jackson.databind.JsonDeserializer;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class FiltersJsonDeserializer
extends JsonDeserializer<List<List<String>>> {
    FiltersJsonDeserializer() {
    }

    @Override
    public List<List<String>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = p.getCurrentToken();
        List<List<String>> result = null;
        switch (currentToken) {
            case START_ARRAY: {
                List list = p.readValueAs(List.class);
                if (list.stream().allMatch(String.class::isInstance)) {
                    result = Collections.singletonList(list);
                    break;
                }
                result = this.buildFilters(list);
                break;
            }
            case VALUE_STRING: {
                result = Collections.singletonList(Arrays.asList(p.getValueAsString().split(",")));
                break;
            }
            case VALUE_NULL: {
                break;
            }
            default: {
                throw new AlgoliaRuntimeException("Unexpected JSON format occurred during the deserialization of filters.");
            }
        }
        return result;
    }

    private List<List<String>> buildFilters(List list) {
        return list.stream().map(element -> {
            if (element instanceof String) {
                return Collections.singletonList((String)element);
            }
            return element;
        }).collect(Collectors.toList());
    }
}

