/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.iterators;

import com.algolia.search.SearchIndex;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.indexing.SearchResult;
import java.util.Iterator;
import java.util.Objects;

abstract class IteratorBase<E>
implements Iterator<E> {
    final SearchIndex<?> index;
    private final RequestOptions requestOptions;
    private boolean isFirstRequest = true;
    private Integer currentPage = 0;
    private Iterator<E> currentIterator = null;

    abstract SearchResult<E> doQuery(Integer var1, RequestOptions var2);

    IteratorBase(@Nonnull SearchIndex<?> index) {
        this(index, 1000, null);
    }

    IteratorBase(@Nonnull SearchIndex<?> index, @Nonnull Integer hitsPerPage) {
        this(index, hitsPerPage, null);
    }

    IteratorBase(@Nonnull SearchIndex<?> index, @Nonnull Integer hitsPerPage, RequestOptions requestOptions) {
        Objects.requireNonNull(index, "Index is required");
        Objects.requireNonNull(hitsPerPage, "hitsPerPage is required");
        this.index = index;
        this.requestOptions = requestOptions;
    }

    @Override
    public boolean hasNext() {
        if (this.isFirstRequest) {
            this.executeQueryAndSetInnerState();
            this.isFirstRequest = false;
        }
        if (this.currentPage != null && !this.currentIterator.hasNext()) {
            this.executeQueryAndSetInnerState();
        }
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.executeQueryAndSetInnerState();
            this.isFirstRequest = false;
        }
        return this.currentIterator.next();
    }

    private void executeQueryAndSetInnerState() {
        SearchResult<E> result = this.doQuery(this.currentPage, this.requestOptions);
        this.currentIterator = result.getHits().iterator();
        if (result.getNbHits() > 0L) {
            Integer n = this.currentPage;
            Integer n2 = this.currentPage = Integer.valueOf(this.currentPage + 1);
        } else {
            this.currentPage = null;
        }
    }
}

