/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.iterators;

import com.algolia.search.SearchIndex;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.indexing.BrowseIndexQuery;
import com.algolia.search.models.indexing.BrowseIndexResponse;
import java.util.Iterator;
import java.util.Objects;

public class IndexIterator<E>
implements Iterator<E> {
    private final SearchIndex<E> index;
    private final RequestOptions requestOptions;
    private final BrowseIndexQuery query;
    private String currentCursor;
    private Iterator<E> currentIterator = null;
    private boolean isFirstRequest = true;

    public IndexIterator(@Nonnull SearchIndex<E> index) {
        this(index, (BrowseIndexQuery)new BrowseIndexQuery().setHitsPerPage(1000));
    }

    public IndexIterator(@Nonnull SearchIndex<E> index, @Nonnull BrowseIndexQuery query) {
        this(index, query, null);
    }

    public IndexIterator(@Nonnull SearchIndex<E> index, @Nonnull BrowseIndexQuery query, RequestOptions requestOptions) {
        Objects.requireNonNull(index, "Index is required");
        Objects.requireNonNull(query, "Query is required");
        this.index = index;
        this.query = query;
        this.requestOptions = requestOptions;
    }

    @Override
    public boolean hasNext() {
        if (this.isFirstRequest) {
            this.browseAndSetInnerState();
            this.isFirstRequest = false;
        }
        if (this.currentCursor != null && !this.currentIterator.hasNext()) {
            this.browseAndSetInnerState();
        }
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.browseAndSetInnerState();
            this.isFirstRequest = false;
        }
        return this.currentIterator.next();
    }

    private void browseAndSetInnerState() {
        BrowseIndexResponse<E> result = this.doQuery(this.query, this.requestOptions);
        this.currentIterator = result.getHits().iterator();
        this.currentCursor = result.getCursor();
        this.query.setCursor(result.getCursor());
    }

    BrowseIndexResponse<E> doQuery(BrowseIndexQuery query, RequestOptions requestOptions) {
        return this.index.browseFrom(query, requestOptions);
    }
}

