/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.HttpTransport;
import com.algolia.search.SearchConfig;
import com.algolia.search.SearchIndexRules;
import com.algolia.search.SearchIndexSearching;
import com.algolia.search.SearchIndexSettings;
import com.algolia.search.SearchIndexSynonyms;
import com.algolia.search.TaskUtils;
import com.algolia.search.exceptions.AlgoliaApiException;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.iterators.IndexIterable;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.WaitableResponse;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.common.TaskStatusResponse;
import com.algolia.search.models.indexing.BatchIndexingResponse;
import com.algolia.search.models.indexing.BatchRequest;
import com.algolia.search.models.indexing.BatchResponse;
import com.algolia.search.models.indexing.BrowseIndexQuery;
import com.algolia.search.models.indexing.BrowseIndexResponse;
import com.algolia.search.models.indexing.CopyToRequest;
import com.algolia.search.models.indexing.CopyToResponse;
import com.algolia.search.models.indexing.DeleteResponse;
import com.algolia.search.models.indexing.MoveIndexRequest;
import com.algolia.search.models.indexing.MoveIndexResponse;
import com.algolia.search.models.indexing.MultiResponse;
import com.algolia.search.models.indexing.MultipleGetObject;
import com.algolia.search.models.indexing.MultipleGetObjectsRequest;
import com.algolia.search.models.indexing.MultipleGetObjectsResponse;
import com.algolia.search.models.indexing.Query;
import com.algolia.search.models.indexing.UpdateObjectResponse;
import com.algolia.search.util.AlgoliaUtils;
import com.algolia.search.util.QueryStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public final class SearchIndex<T>
implements SearchIndexRules<T>,
SearchIndexSynonyms<T>,
SearchIndexSettings<T>,
SearchIndexSearching<T> {
    private final HttpTransport transport;
    private final SearchConfig config;
    private final String urlEncodedIndexName;
    private final String indexName;
    private final Class<T> clazz;

    SearchIndex(HttpTransport transport, ConfigBase config, String indexName, Class<T> clazz) {
        this.transport = transport;
        this.config = (SearchConfig)config;
        this.indexName = indexName;
        this.urlEncodedIndexName = QueryStringUtils.urlEncodeUTF8(indexName);
        this.clazz = clazz;
    }

    @Override
    public SearchConfig getConfig() {
        return this.config;
    }

    @Override
    public Class<T> getClazz() {
        return this.clazz;
    }

    @Override
    public HttpTransport getTransport() {
        return this.transport;
    }

    @Override
    public String getUrlEncodedIndexName() {
        return this.urlEncodedIndexName;
    }

    public T getObject(@Nonnull String objectID) {
        return LaunderThrowable.await(this.getObjectAsync(objectID));
    }

    public T getObject(@Nonnull String objectID, @Nonnull List<String> attributesToRetrieve, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getObjectAsync(objectID, attributesToRetrieve, requestOptions));
    }

    public T getObject(@Nonnull String objectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getObjectAsync(objectID, requestOptions));
    }

    public CompletableFuture<T> getObjectAsync(@Nonnull String objectID) {
        return this.getObjectAsync(objectID, null);
    }

    public CompletableFuture<T> getObjectAsync(@Nonnull String objectID, @Nonnull List<String> attributesToRetrieve, RequestOptions requestOptions) {
        Objects.requireNonNull(attributesToRetrieve, "AttributesToRetrieve are required.");
        Objects.requireNonNull(objectID, "objectID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("attributesToRetrieve", QueryStringUtils.urlEncodeUTF8(String.join((CharSequence)",", attributesToRetrieve)));
        return this.getObjectAsync(objectID, requestOptions);
    }

    public CompletableFuture<T> getObjectAsync(@Nonnull String objectID, RequestOptions requestOptions) {
        Objects.requireNonNull(objectID, "objectID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        return this.transport.executeRequestAsync(HttpMethod.GET, "/1/indexes/" + this.urlEncodedIndexName + "/" + QueryStringUtils.urlEncodeUTF8(objectID), CallType.READ, this.clazz, requestOptions);
    }

    public List<T> getObjects(@Nonnull List<String> objectIDs) {
        return LaunderThrowable.await(this.getObjectsAsync(objectIDs));
    }

    public List<T> getObjects(@Nonnull List<String> objectIDs, List<String> attributesToRetrieve) {
        return LaunderThrowable.await(this.getObjectsAsync(objectIDs, attributesToRetrieve));
    }

    public List<T> getObjects(@Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getObjectsAsync(objectIDs, requestOptions));
    }

    public List<T> getObjects(@Nonnull List<String> objectIDs, List<String> attributesToRetrieve, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getObjectsAsync(objectIDs, attributesToRetrieve, requestOptions));
    }

    public CompletableFuture<List<T>> getObjectsAsync(@Nonnull List<String> objectIDs) {
        return this.getObjectsAsync(objectIDs, null, null);
    }

    public CompletableFuture<List<T>> getObjectsAsync(@Nonnull List<String> objectIDs, List<String> attributesToRetrieve) {
        return this.getObjectsAsync(objectIDs, attributesToRetrieve, null);
    }

    public CompletableFuture<List<T>> getObjectsAsync(@Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return this.getObjectsAsync(objectIDs, null, requestOptions);
    }

    public CompletableFuture<List<T>> getObjectsAsync(@Nonnull List<String> objectIDs, List<String> attributesToRetrieve, RequestOptions requestOptions) {
        Objects.requireNonNull(objectIDs, "Object IDs are required.");
        if (objectIDs.isEmpty()) {
            throw new IllegalArgumentException("objectIDs can't be empty.");
        }
        ArrayList<MultipleGetObject> queries = new ArrayList<MultipleGetObject>();
        for (String objectId : objectIDs) {
            queries.add(new MultipleGetObject(this.indexName, objectId, attributesToRetrieve));
        }
        MultipleGetObjectsRequest request = new MultipleGetObjectsRequest(queries);
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/*/objects", CallType.READ, request, MultipleGetObjectsResponse.class, this.clazz, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture r = new CompletableFuture();
            r.complete(resp.getResults());
            return r;
        }, (Executor)this.config.getExecutor());
    }

    public UpdateObjectResponse partialUpdateObject(@Nonnull T data) {
        return LaunderThrowable.await(this.partialUpdateObjectAsync(data));
    }

    public UpdateObjectResponse partialUpdateObject(@Nonnull T data, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.partialUpdateObjectAsync(data, requestOptions));
    }

    public UpdateObjectResponse partialUpdateObject(@Nonnull T data, @Nonnull Boolean createIfNotExists) {
        return LaunderThrowable.await(this.partialUpdateObjectAsync(data, createIfNotExists));
    }

    public UpdateObjectResponse partialUpdateObject(@Nonnull T data, @Nonnull Boolean createIfNotExists, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.partialUpdateObjectAsync(data, createIfNotExists, requestOptions));
    }

    public CompletableFuture<UpdateObjectResponse> partialUpdateObjectAsync(@Nonnull T data) {
        return this.partialUpdateObjectAsync(data, false, null);
    }

    public CompletableFuture<UpdateObjectResponse> partialUpdateObjectAsync(@Nonnull T data, RequestOptions requestOptions) {
        return this.partialUpdateObjectAsync(data, false, requestOptions);
    }

    public CompletableFuture<UpdateObjectResponse> partialUpdateObjectAsync(@Nonnull T data, @Nonnull Boolean createIfNotExists) {
        return this.partialUpdateObjectAsync(data, createIfNotExists, null);
    }

    public CompletableFuture<UpdateObjectResponse> partialUpdateObjectAsync(@Nonnull T data, @Nonnull Boolean createIfNotExists, RequestOptions requestOptions) {
        Objects.requireNonNull(data, "Data is required.");
        Objects.requireNonNull(createIfNotExists, "createIfNotExists is required.");
        String objectID = AlgoliaUtils.getObjectID(data, this.clazz);
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("createIfNotExists", createIfNotExists.toString());
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.urlEncodedIndexName + "/" + objectID + "/partial", CallType.WRITE, data, UpdateObjectResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    public BatchIndexingResponse partialUpdateObjects(@Nonnull Iterable<T> data) {
        return LaunderThrowable.await(this.partialUpdateObjectsAsync(data));
    }

    public BatchIndexingResponse partialUpdateObjects(@Nonnull Iterable<T> data, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.partialUpdateObjectsAsync(data, requestOptions));
    }

    public BatchIndexingResponse partialUpdateObjects(@Nonnull Iterable<T> data, boolean createIfNotExists) {
        return LaunderThrowable.await(this.partialUpdateObjectsAsync(data, createIfNotExists));
    }

    public BatchIndexingResponse partialUpdateObjects(@Nonnull Iterable<T> data, boolean createIfNotExists, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.partialUpdateObjectsAsync(data, createIfNotExists, requestOptions));
    }

    public CompletableFuture<BatchIndexingResponse> partialUpdateObjectsAsync(@Nonnull Iterable<T> data) {
        return this.partialUpdateObjectsAsync(data, false, null);
    }

    public CompletableFuture<BatchIndexingResponse> partialUpdateObjectsAsync(@Nonnull Iterable<T> data, RequestOptions requestOptions) {
        return this.partialUpdateObjectsAsync(data, false, requestOptions);
    }

    public CompletableFuture<BatchIndexingResponse> partialUpdateObjectsAsync(@Nonnull Iterable<T> data, boolean createIfNotExists) {
        return this.partialUpdateObjectsAsync(data, createIfNotExists, null);
    }

    public CompletableFuture<BatchIndexingResponse> partialUpdateObjectsAsync(@Nonnull Iterable<T> data, boolean createIfNotExists, RequestOptions requestOptions) {
        Objects.requireNonNull(data, "Data are required.");
        String action = createIfNotExists ? "partialUpdateObject" : "partialUpdateObjectNoCreate";
        return this.splitIntoBatchesAsync(data, action, requestOptions);
    }

    public BatchIndexingResponse saveObject(@Nonnull T data) {
        return LaunderThrowable.await(this.saveObjectAsync(data));
    }

    public BatchIndexingResponse saveObject(@Nonnull T data, boolean autoGenerateObjectID) {
        return LaunderThrowable.await(this.saveObjectAsync(data, autoGenerateObjectID));
    }

    public BatchIndexingResponse saveObject(@Nonnull T data, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveObjectAsync(data, requestOptions));
    }

    public BatchIndexingResponse saveObject(@Nonnull T data, boolean autoGenerateObjectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveObjectAsync(data, autoGenerateObjectID, requestOptions));
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectAsync(@Nonnull T data) {
        return this.saveObjectAsync(data, false, null);
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectAsync(@Nonnull T data, boolean autoGenerateObjectID) {
        return this.saveObjectAsync(data, autoGenerateObjectID, null);
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectAsync(@Nonnull T data, RequestOptions requestOptions) {
        return this.saveObjectAsync(data, false, requestOptions);
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectAsync(@Nonnull T data, boolean autoGenerateObjectID, RequestOptions requestOptions) {
        Objects.requireNonNull(data, "Data are required.");
        return this.saveObjectsAsync(Collections.singletonList(data), autoGenerateObjectID, requestOptions);
    }

    public BatchIndexingResponse saveObjects(@Nonnull Iterable<T> data) {
        return LaunderThrowable.await(this.saveObjectsAsync(data));
    }

    public BatchIndexingResponse saveObjects(@Nonnull Iterable<T> data, boolean autoGenerateObjectID) {
        return LaunderThrowable.await(this.saveObjectsAsync(data, autoGenerateObjectID));
    }

    public BatchIndexingResponse saveObjects(@Nonnull Iterable<T> data, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveObjectsAsync(data, requestOptions));
    }

    public BatchIndexingResponse saveObjects(@Nonnull Iterable<T> data, boolean autoGenerateObjectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveObjectsAsync(data, autoGenerateObjectID, requestOptions));
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectsAsync(@Nonnull Iterable<T> data) {
        return this.saveObjectsAsync(data, false, null);
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectsAsync(@Nonnull Iterable<T> data, boolean autoGenerateObjectID) {
        return this.saveObjectsAsync(data, autoGenerateObjectID, null);
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectsAsync(@Nonnull Iterable<T> data, RequestOptions requestOptions) {
        return this.saveObjectsAsync(data, false, requestOptions);
    }

    public CompletableFuture<BatchIndexingResponse> saveObjectsAsync(@Nonnull Iterable<T> data, boolean autoGenerateObjectID, RequestOptions requestOptions) {
        Objects.requireNonNull(data, "Data are required.");
        if (autoGenerateObjectID) {
            return this.splitIntoBatchesAsync(data, "addObject", requestOptions);
        }
        AlgoliaUtils.ensureObjectID(this.clazz);
        return this.splitIntoBatchesAsync(data, "updateObject", requestOptions);
    }

    <E> CompletableFuture<BatchIndexingResponse> splitIntoBatchesAsync(@Nonnull Iterable<E> data, @Nonnull String actionType) {
        return this.splitIntoBatchesAsync(data, actionType, null);
    }

    <E> CompletableFuture<BatchIndexingResponse> splitIntoBatchesAsync(@Nonnull Iterable<E> data, @Nonnull String actionType, RequestOptions requestOptions) {
        Objects.requireNonNull(data, "Data are required.");
        Objects.requireNonNull(actionType, "An action type is required.");
        ArrayList<CompletableFuture<BatchResponse>> futures = new ArrayList<CompletableFuture<BatchResponse>>();
        ArrayList<E> records = new ArrayList<E>();
        for (E item : data) {
            if (records.size() == this.config.getBatchSize()) {
                BatchRequest request = new BatchRequest(actionType, records);
                CompletableFuture<BatchResponse> batch = this.batchAsync(request, requestOptions);
                futures.add(batch);
                records.clear();
            }
            records.add(item);
        }
        if (records.size() > 0) {
            BatchRequest request = new BatchRequest(actionType, records);
            CompletableFuture<BatchResponse> batch = this.batchAsync(request, requestOptions);
            futures.add(batch);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenComposeAsync(v -> {
            List<BatchResponse> resp = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new BatchIndexingResponse(resp));
        }, (Executor)this.config.getExecutor());
    }

    public <E> BatchResponse batch(@Nonnull BatchRequest<E> request) {
        return LaunderThrowable.await(this.batchAsync(request, null));
    }

    public <E> BatchResponse batch(@Nonnull BatchRequest<E> request, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.batchAsync(request, requestOptions));
    }

    public <E> CompletableFuture<BatchResponse> batchAsync(@Nonnull BatchRequest<E> request) {
        return this.batchAsync(request, null);
    }

    public <E> CompletableFuture<BatchResponse> batchAsync(@Nonnull BatchRequest<E> request, RequestOptions requestOptions) {
        Objects.requireNonNull(request, "A BatchRequest is required.");
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.urlEncodedIndexName + "/batch", CallType.WRITE, request, BatchResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    public DeleteResponse deleteObject(@Nonnull String objectID) {
        return LaunderThrowable.await(this.deleteObjectAsync(objectID, null));
    }

    public DeleteResponse deleteObject(@Nonnull String objectID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteObjectAsync(objectID, requestOptions));
    }

    public CompletableFuture<DeleteResponse> deleteObjectAsync(@Nonnull String objectID) {
        return this.deleteObjectAsync(objectID, null);
    }

    public CompletableFuture<DeleteResponse> deleteObjectAsync(@Nonnull String objectID, RequestOptions requestOptions) {
        Objects.requireNonNull(objectID, "The objectID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(objectID).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        return this.transport.executeRequestAsync(HttpMethod.DELETE, "/1/indexes/" + this.urlEncodedIndexName + "/" + objectID, CallType.WRITE, DeleteResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    public BatchIndexingResponse deleteObjects(@Nonnull List<String> objectIDs) {
        return LaunderThrowable.await(this.deleteObjectsAsync(objectIDs));
    }

    public BatchIndexingResponse deleteObjects(@Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteObjectsAsync(objectIDs, requestOptions));
    }

    public CompletableFuture<BatchIndexingResponse> deleteObjectsAsync(@Nonnull List<String> objectIDs) {
        return this.deleteObjectsAsync(objectIDs, null);
    }

    public CompletableFuture<BatchIndexingResponse> deleteObjectsAsync(@Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        Objects.requireNonNull(objectIDs, "The objectID is required.");
        if (objectIDs.isEmpty()) {
            throw new IllegalArgumentException("objectIDs can't be empty.");
        }
        ArrayList request = new ArrayList();
        for (String id : objectIDs) {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("objectID", id);
            request.add(tmp);
        }
        return this.splitIntoBatchesAsync(request, "deleteObject", requestOptions);
    }

    public DeleteResponse clearObjects() {
        return LaunderThrowable.await(this.clearObjectsAsync(null));
    }

    public DeleteResponse clearObjects(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clearObjectsAsync(requestOptions));
    }

    public CompletableFuture<DeleteResponse> clearObjectsAsync() {
        return this.clearObjectsAsync(null);
    }

    public CompletableFuture<DeleteResponse> clearObjectsAsync(RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.urlEncodedIndexName + "/clear", CallType.WRITE, DeleteResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    public MultiResponse replaceAllObjects(Iterable<T> data) {
        return LaunderThrowable.await(this.replaceAllObjectsAsync(data));
    }

    public MultiResponse replaceAllObjects(Iterable<T> data, boolean safe) {
        return LaunderThrowable.await(this.replaceAllObjectsAsync(data, safe));
    }

    public MultiResponse replaceAllObjects(Iterable<T> data, RequestOptions requestOptions, boolean safe) {
        return LaunderThrowable.await(this.replaceAllObjectsAsync(data, requestOptions, safe));
    }

    public CompletableFuture<MultiResponse> replaceAllObjectsAsync(Iterable<T> data) {
        return this.replaceAllObjectsAsync(data, null, false);
    }

    public CompletableFuture<MultiResponse> replaceAllObjectsAsync(Iterable<T> data, boolean safe) {
        return this.replaceAllObjectsAsync(data, null, safe);
    }

    public CompletableFuture<MultiResponse> replaceAllObjectsAsync(Iterable<T> data, RequestOptions requestOptions, boolean safe) {
        Objects.requireNonNull(data, "Data can't be null");
        Random rnd = new Random();
        String tmpIndexName = this.indexName + "_tmp_" + rnd.nextInt(100);
        SearchIndex<T> tmpIndex = new SearchIndex<T>(this.transport, this.config, tmpIndexName, this.clazz);
        List<String> scopes = Arrays.asList("rules", "settings", "synonyms");
        ArrayList<CompletableFuture<WaitableResponse>> futures = new ArrayList<CompletableFuture<WaitableResponse>>();
        CompletableFuture<CopyToResponse> copyResponseFuture = this.copyToAsync(tmpIndexName, scopes, requestOptions);
        futures.add(copyResponseFuture);
        if (safe) {
            copyResponseFuture.join().waitTask();
        }
        CompletableFuture<BatchIndexingResponse> saveObjectsFuture = tmpIndex.saveObjectsAsync(data, requestOptions);
        futures.add(saveObjectsFuture);
        if (safe) {
            saveObjectsFuture.join().waitTask();
        }
        CompletableFuture<MoveIndexResponse> moveIndexFuture = this.moveFromAsync(QueryStringUtils.urlEncodeUTF8(tmpIndexName), requestOptions);
        futures.add(moveIndexFuture);
        if (safe) {
            moveIndexFuture.join().waitTask();
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenComposeAsync(v -> {
            List<WaitableResponse> resp = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
            return CompletableFuture.completedFuture(new MultiResponse().setResponses(resp));
        }, (Executor)this.config.getExecutor());
    }

    public MoveIndexResponse moveFrom(@Nonnull String sourceIndex) {
        return LaunderThrowable.await(this.moveFromAsync(sourceIndex));
    }

    public MoveIndexResponse moveFrom(@Nonnull String sourceIndex, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.moveFromAsync(sourceIndex, requestOptions));
    }

    public CompletableFuture<MoveIndexResponse> moveFromAsync(@Nonnull String sourceIndex) {
        return this.moveFromAsync(sourceIndex, null);
    }

    public CompletableFuture<MoveIndexResponse> moveFromAsync(@Nonnull String sourceIndex, RequestOptions requestOptions) {
        Objects.requireNonNull(sourceIndex, "sourceIndex can't be null.");
        if (AlgoliaUtils.isEmptyWhiteSpace(sourceIndex).booleanValue()) {
            throw new AlgoliaRuntimeException("sourceIndex is required.");
        }
        MoveIndexRequest request = new MoveIndexRequest().setOperation("move").setDestination(this.indexName);
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + sourceIndex + "/operation", CallType.WRITE, request, MoveIndexResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    CompletableFuture<CopyToResponse> copyToAsync(@Nonnull String destinationIndex, List<String> scope, RequestOptions requestOptions) {
        if (AlgoliaUtils.isEmptyWhiteSpace(destinationIndex).booleanValue()) {
            throw new AlgoliaRuntimeException("destinationIndex is required.");
        }
        CopyToRequest request = new CopyToRequest().setOperation("copy").setDestination(destinationIndex).setScope(scope);
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.urlEncodedIndexName + "/operation", CallType.WRITE, request, CopyToResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    public IndexIterable<T> browseObjects(@Nonnull BrowseIndexQuery query) {
        return new IndexIterable(this, query);
    }

    public BrowseIndexResponse<T> browseFrom(@Nonnull BrowseIndexQuery query) {
        return LaunderThrowable.await(this.browseFromAsync(query, null));
    }

    public BrowseIndexResponse<T> browseFrom(@Nonnull BrowseIndexQuery query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.browseFromAsync(query, requestOptions));
    }

    public CompletableFuture<BrowseIndexResponse<T>> browseFromAsync(@Nonnull BrowseIndexQuery query) {
        return this.browseFromAsync(query, null);
    }

    public CompletableFuture<BrowseIndexResponse<T>> browseFromAsync(@Nonnull BrowseIndexQuery query, RequestOptions requestOptions) {
        Objects.requireNonNull(query, "A query is required.");
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.urlEncodedIndexName + "/browse", CallType.READ, query, BrowseIndexResponse.class, this.clazz, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<BrowseIndexResponse> r = new CompletableFuture<BrowseIndexResponse>();
            r.complete((BrowseIndexResponse)resp);
            return r;
        }, (Executor)this.config.getExecutor());
    }

    public DeleteResponse delete() {
        return LaunderThrowable.await(this.deleteAsync());
    }

    public DeleteResponse delete(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteAsync(requestOptions));
    }

    public CompletableFuture<DeleteResponse> deleteAsync() {
        return this.deleteAsync(null);
    }

    public CompletableFuture<DeleteResponse> deleteAsync(RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.DELETE, "/1/indexes/" + this.urlEncodedIndexName, CallType.WRITE, DeleteResponse.class, requestOptions);
    }

    public DeleteResponse deleteBy(@Nonnull Query query) {
        return LaunderThrowable.await(this.deleteByAsync(query));
    }

    public DeleteResponse deleteBy(@Nonnull Query query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteByAsync(query, requestOptions));
    }

    public CompletableFuture<DeleteResponse> deleteByAsync(@Nonnull Query query) {
        return this.deleteByAsync(query, null);
    }

    public CompletableFuture<DeleteResponse> deleteByAsync(@Nonnull Query query, RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/" + this.urlEncodedIndexName + "/deleteByQuery", CallType.WRITE, query, DeleteResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.config.getExecutor());
    }

    public TaskStatusResponse getTask(long taskID) {
        return LaunderThrowable.await(this.getTaskAsync(taskID));
    }

    public TaskStatusResponse getTask(long taskID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getTaskAsync(taskID, requestOptions));
    }

    public CompletableFuture<TaskStatusResponse> getTaskAsync(long taskID) {
        return this.getTaskAsync(taskID, null);
    }

    public CompletableFuture<TaskStatusResponse> getTaskAsync(long taskID, RequestOptions requestOptions) {
        return this.transport.executeRequestAsync(HttpMethod.GET, "/1/indexes/" + this.urlEncodedIndexName + "/task/" + taskID, CallType.READ, TaskStatusResponse.class, requestOptions);
    }

    public boolean exists() {
        return LaunderThrowable.await(this.existsAsync());
    }

    public CompletableFuture<Boolean> existsAsync() {
        try {
            this.getSettings();
        }
        catch (AlgoliaApiException ex) {
            if (ex.getHttpErrorCode() == 404) {
                return CompletableFuture.completedFuture(false);
            }
            throw ex;
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public void waitTask(long taskId) {
        this.waitTask(taskId, 100L, null);
    }

    @Override
    public void waitTask(long taskId, long timeToWait, RequestOptions requestOptions) {
        TaskUtils.waitTask(taskId, timeToWait, requestOptions, this::getTaskAsync);
    }
}

