/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.StatefulHost;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.common.CompressionType;
import com.algolia.search.util.AlgoliaUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class InsightsConfig
extends ConfigBase {
    private InsightsConfig(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends ConfigBase.Builder<Builder> {
        public Builder(@Nonnull String applicationID, @Nonnull String apiKey) {
            this(applicationID, apiKey, "us");
        }

        public Builder(@Nonnull String applicationID, @Nonnull String apiKey, @Nonnull String region) {
            super(applicationID, apiKey, Builder.createDefaultHosts(region), CompressionType.NONE);
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public InsightsConfig build() {
            return new InsightsConfig(this);
        }

        private static List<StatefulHost> createDefaultHosts(@Nonnull String region) {
            if (AlgoliaUtils.isEmptyWhiteSpace(region).booleanValue()) {
                throw new NullPointerException("The region can't be empty.");
            }
            return Collections.singletonList(new StatefulHost("insights." + region + ".algolia.io", EnumSet.of(CallType.READ, CallType.WRITE)));
        }
    }
}

