/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.HttpRequester;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.HttpRequest;
import com.algolia.search.org.apache.http.Header;
import com.algolia.search.org.apache.http.HeaderElement;
import com.algolia.search.org.apache.http.HttpEntity;
import com.algolia.search.org.apache.http.HttpException;
import com.algolia.search.org.apache.http.HttpResponse;
import com.algolia.search.org.apache.http.NoHttpResponseException;
import com.algolia.search.org.apache.http.client.config.RequestConfig;
import com.algolia.search.org.apache.http.client.entity.DeflateDecompressingEntity;
import com.algolia.search.org.apache.http.client.entity.GzipDecompressingEntity;
import com.algolia.search.org.apache.http.client.methods.HttpDelete;
import com.algolia.search.org.apache.http.client.methods.HttpGet;
import com.algolia.search.org.apache.http.client.methods.HttpPatch;
import com.algolia.search.org.apache.http.client.methods.HttpPost;
import com.algolia.search.org.apache.http.client.methods.HttpPut;
import com.algolia.search.org.apache.http.client.methods.HttpRequestBase;
import com.algolia.search.org.apache.http.concurrent.FutureCallback;
import com.algolia.search.org.apache.http.conn.ConnectTimeoutException;
import com.algolia.search.org.apache.http.conn.ConnectionPoolTimeoutException;
import com.algolia.search.org.apache.http.entity.ContentType;
import com.algolia.search.org.apache.http.entity.InputStreamEntity;
import com.algolia.search.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.algolia.search.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import com.algolia.search.org.apache.http.util.EntityUtils;
import com.algolia.search.util.HttpStatusCodeUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

public final class ApacheHttpRequester
implements HttpRequester {
    private final CloseableHttpAsyncClient asyncHttpClient;
    private final RequestConfig requestConfig;
    private final ConfigBase config;

    public ApacheHttpRequester(@Nonnull ConfigBase config) {
        this(config, config.getUseSystemProxy() ? HttpAsyncClientBuilder.create().useSystemProperties() : HttpAsyncClientBuilder.create().setMaxConnPerRoute(100));
    }

    public ApacheHttpRequester(@Nonnull ConfigBase config, @Nonnull HttpAsyncClientBuilder builder) {
        this.config = config;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectTimeOut()).setContentCompressionEnabled(true).build();
        this.asyncHttpClient = builder.build();
        this.asyncHttpClient.start();
    }

    @Override
    public CompletableFuture<com.algolia.search.models.HttpResponse> performRequestAsync(HttpRequest request) {
        HttpRequestBase requestToSend = this.buildRequest(request);
        return ((CompletableFuture)ApacheHttpRequester.toCompletableFuture(fc -> this.asyncHttpClient.execute(requestToSend, (FutureCallback<HttpResponse>)fc)).thenApplyAsync(this::buildResponse, (Executor)this.config.getExecutor())).exceptionally(t -> {
            if (t.getCause() instanceof ConnectTimeoutException || t.getCause() instanceof SocketTimeoutException || t.getCause() instanceof ConnectException || t.getCause() instanceof TimeoutException || t.getCause() instanceof ConnectionPoolTimeoutException || t.getCause() instanceof NoHttpResponseException) {
                return new com.algolia.search.models.HttpResponse(true);
            }
            if (t.getCause() instanceof HttpException || t.getCause() instanceof SSLException) {
                return new com.algolia.search.models.HttpResponse().setNetworkError(true);
            }
            throw new AlgoliaRuntimeException((Throwable)t);
        });
    }

    @Override
    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    private com.algolia.search.models.HttpResponse buildResponse(HttpResponse response) {
        try {
            if (HttpStatusCodeUtils.isSuccess(response.getStatusLine().getStatusCode())) {
                HttpEntity entity = ApacheHttpRequester.handleCompressedEntity(response.getEntity());
                return new com.algolia.search.models.HttpResponse(response.getStatusLine().getStatusCode(), entity.getContent());
            }
            return new com.algolia.search.models.HttpResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException(e);
        }
    }

    private HttpRequestBase buildRequest(HttpRequest algoliaRequest) {
        switch (algoliaRequest.getMethod().toString()) {
            case "GET": {
                HttpGet get = new HttpGet(algoliaRequest.getUri().toString());
                get.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders(get, algoliaRequest.getHeaders());
            }
            case "DELETE": {
                HttpDelete delete = new HttpDelete(algoliaRequest.getUri().toString());
                delete.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders(delete, algoliaRequest.getHeaders());
            }
            case "POST": {
                HttpPost post = new HttpPost(algoliaRequest.getUri().toString());
                if (algoliaRequest.getBody() != null) {
                    post.setEntity(this.addEntity(algoliaRequest));
                }
                post.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders(post, algoliaRequest.getHeaders());
            }
            case "PUT": {
                HttpPut put = new HttpPut(algoliaRequest.getUri().toString());
                if (algoliaRequest.getBody() != null) {
                    put.setEntity(this.addEntity(algoliaRequest));
                }
                put.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders(put, algoliaRequest.getHeaders());
            }
            case "PATCH": {
                HttpPatch patch = new HttpPatch(algoliaRequest.getUri().toString());
                if (algoliaRequest.getBody() != null) {
                    patch.setEntity(this.addEntity(algoliaRequest));
                }
                patch.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders(patch, algoliaRequest.getHeaders());
            }
        }
        throw new UnsupportedOperationException("HTTP method not supported: " + algoliaRequest.getMethod().toString());
    }

    private RequestConfig buildRequestConfig(HttpRequest algoliaRequest) {
        return RequestConfig.copy(this.requestConfig).setSocketTimeout(algoliaRequest.getTimeout()).build();
    }

    private HttpRequestBase addHeaders(HttpRequestBase request, Map<String, String> headers) {
        headers.forEach(request::addHeader);
        return request;
    }

    private HttpEntity addEntity(@Nonnull HttpRequest request) {
        try {
            InputStreamEntity entity = new InputStreamEntity(request.getBody(), request.getBody().available(), ContentType.APPLICATION_JSON);
            if (request.canCompress()) {
                entity.setContentEncoding("gzip");
            }
            return entity;
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException("Error while getting body's content length.", e);
        }
    }

    private static HttpEntity handleCompressedEntity(HttpEntity entity) {
        Header contentEncoding = entity.getContentEncoding();
        if (contentEncoding != null) {
            for (HeaderElement e : contentEncoding.getElements()) {
                if ("gzip".equalsIgnoreCase(e.getName())) {
                    return new GzipDecompressingEntity(entity);
                }
                if (!"deflate".equalsIgnoreCase(e.getName())) continue;
                return new DeflateDecompressingEntity(entity);
            }
        }
        return entity;
    }

    private static CompletableFuture<HttpResponse> toCompletableFuture(Consumer<FutureCallback<HttpResponse>> c) {
        final CompletableFuture<HttpResponse> promise = new CompletableFuture<HttpResponse>();
        c.accept(new FutureCallback<HttpResponse>(){

            @Override
            public void completed(HttpResponse t) {
                promise.complete(t);
            }

            @Override
            public void failed(Exception e) {
                promise.completeExceptionally(e);
            }

            @Override
            public void cancelled() {
                promise.cancel(true);
            }
        });
        return promise;
    }
}

