/*
 * Decompiled with CFR 0.152.
 */
package com.alexzh.circleimageview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.alexzh.circleimageview.ItemSelectedListener;
import com.alexzh.circleimageview.R;

public class CircleImageView
extends ImageView {
    private static final String TAG = "CIRCLE_IMAGE_VIEW";
    private static final float CIRCLE_DEGREE = 360.0f;
    private static final float BORDER_WIDTH = 0.0f;
    private static final float SHADOW_RADIUS = 0.0f;
    private static final float SHADOW_DX = 2.0f;
    private static final float SHADOW_DY = 2.0f;
    private boolean mHasBorder;
    private float mBorderWidth;
    private int mBorderColor;
    private int mBorderSelectedColor;
    private boolean mIsSelected;
    private boolean mHasShadow;
    private float mShadowDx;
    private float mShadowDy;
    private float mShadowRadius;
    private int mShadowColor;
    private Paint mImagePaint;
    private Paint mBorderPaint;
    private Paint mBackgroundPaint;
    private Bitmap mImage;
    private int mMinCanvasSide;
    private BitmapShader mBitmapShader;
    private ItemSelectedListener mListener;

    public CircleImageView(Context context) {
        this(context, null, R.styleable.CircleImageViewStyle_circleImageViewDefault);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.styleable.CircleImageViewStyle_circleImageViewDefault);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        this.mImagePaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mBackgroundPaint = new Paint();
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyle, 0);
        int backgroundColor = attributes.getColor(R.styleable.CircleImageView_view_backgroundColor, context.getResources().getColor(17170445));
        this.mBorderWidth = attributes.getDimension(R.styleable.CircleImageView_view_borderWidth, 0.0f);
        this.mShadowRadius = attributes.getDimension(R.styleable.CircleImageView_view_shadowRadius, 0.0f);
        this.setBackgroundColor(backgroundColor);
        this.mImagePaint.setAntiAlias(true);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        if (this.mBorderWidth > 0.0f) {
            this.mBorderColor = attributes.getColor(R.styleable.CircleImageView_view_borderColor, context.getResources().getColor(17170443));
            this.mBorderSelectedColor = attributes.getColor(R.styleable.CircleImageView_view_selectedColor, context.getResources().getColor(17170443));
            this.setBorderWidth(this.mBorderWidth);
            this.setBorderColor(this.mBorderColor);
            this.mHasBorder = true;
        }
        if (this.mShadowRadius > 0.0f) {
            this.mShadowDx = attributes.getDimension(R.styleable.CircleImageView_view_shadowDx, 2.0f);
            this.mShadowDy = attributes.getDimension(R.styleable.CircleImageView_view_shadowDy, 2.0f);
            this.mShadowColor = attributes.getColor(R.styleable.CircleImageView_view_shadowColor, context.getResources().getColor(17170444));
            this.mHasShadow = true;
            this.drawShadow();
        }
        attributes.recycle();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        float minShadowValue = this.mShadowDx > this.mShadowDy ? this.mShadowDx : this.mShadowDy;
        int oldCanvasSize = this.mMinCanvasSide;
        int n = this.mMinCanvasSide = this.getMeasuredWidth() < this.getMeasuredHeight() ? this.getMeasuredWidth() : this.getMeasuredHeight();
        if (oldCanvasSize != this.mMinCanvasSide) {
            this.updateBitmapShader();
        }
        this.mImagePaint.setShader((Shader)this.mBitmapShader);
        float centerX = ((float)this.getMeasuredWidth() - this.mShadowRadius + minShadowValue) / 2.0f;
        float centerY = ((float)this.getMeasuredHeight() - this.mShadowRadius + minShadowValue) / 2.0f;
        float radius = ((float)this.mMinCanvasSide - this.mShadowRadius) / 2.0f - this.mBorderWidth - minShadowValue;
        if (this.mHasBorder) {
            if (this.mHasShadow) {
                this.mMinCanvasSide = (int)((float)this.mMinCanvasSide - this.mShadowRadius - minShadowValue);
            }
            RectF rect = this.getBorderRectF(minShadowValue);
            if (this.mIsSelected) {
                this.setBorderColor(this.mBorderSelectedColor);
                canvas.drawArc(rect, 360.0f, 360.0f, false, this.mBorderPaint);
            } else {
                this.setBorderColor(this.mBorderColor);
                canvas.drawArc(rect, 360.0f, 360.0f, false, this.mBorderPaint);
            }
        }
        canvas.drawCircle(centerX, centerY, radius, this.mBackgroundPaint);
        canvas.drawCircle(centerX, centerY, radius, this.mImagePaint);
    }

    private RectF getBorderRectF(float minShadowValue) {
        return new RectF((0.0f + this.mBorderWidth + this.mShadowRadius) / 2.0f + minShadowValue, (0.0f + this.mBorderWidth + this.mShadowRadius) / 2.0f + minShadowValue, (float)this.mMinCanvasSide - (this.mBorderWidth - this.mShadowRadius) / 2.0f - minShadowValue, (float)this.mMinCanvasSide - (this.mBorderWidth - this.mShadowRadius) / 2.0f - minShadowValue);
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (!this.isClickable()) {
            this.mIsSelected = false;
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                boolean bl = this.mIsSelected = !this.mIsSelected;
                if (this.mIsSelected && this.mListener != null) {
                    this.mListener.onSelected((View)this);
                    break;
                }
                if (this.mIsSelected || this.mListener == null) break;
                this.mListener.onUnselected((View)this);
            }
        }
        this.invalidate();
        return super.dispatchTouchEvent(event);
    }

    private void drawShadow() {
        if (this.mHasBorder) {
            this.mBorderPaint.setShadowLayer(this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mShadowColor);
        } else {
            this.mBackgroundPaint.setShadowLayer(this.mShadowRadius, this.mShadowDx, this.mShadowDy, this.mShadowColor);
        }
    }

    public void setOnItemSelectedClickListener(ItemSelectedListener listener) {
        this.mListener = listener;
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.mBackgroundPaint != null) {
            this.mBackgroundPaint.setColor(backgroundColor);
        }
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        if (this.mBorderPaint != null) {
            this.mBorderPaint.setColor(borderColor);
        }
        this.invalidate();
    }

    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
        if (this.mBorderPaint != null) {
            this.mBorderPaint.setStrokeWidth(borderWidth);
        }
        this.requestLayout();
        this.invalidate();
    }

    public Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            Log.i((String)TAG, (String)"Bitmap drawable!");
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        int intrinsicHeight = drawable.getIntrinsicHeight();
        if (intrinsicWidth <= 0 || intrinsicHeight <= 0) {
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)intrinsicWidth, (int)intrinsicHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"Encountered OutOfMemoryError while generating bitmap!");
            return null;
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.mImage = this.drawableToBitmap(this.getDrawable());
        if (this.mMinCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.mImage = this.drawableToBitmap(this.getDrawable());
        if (this.mMinCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.mImage = this.drawableToBitmap(this.getDrawable());
        if (this.mMinCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mImage = bm;
        if (this.mMinCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void updateBitmapShader() {
        if (this.mImage == null) {
            return;
        }
        this.mBitmapShader = new BitmapShader(this.mImage, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (this.mMinCanvasSide != this.mImage.getWidth() || this.mMinCanvasSide != this.mImage.getHeight()) {
            Matrix matrix = new Matrix();
            float scale = (float)this.mMinCanvasSide / (float)this.mImage.getWidth();
            matrix.setScale(scale, scale);
            this.mBitmapShader.setLocalMatrix(matrix);
        }
    }
}

