/*
 * Decompiled with CFR 0.152.
 */
package com.alexzh.circleimageview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.alexzh.circleimageview.ItemSelectedListener;
import com.alexzh.circleimageview.R;

public class CircleImageView
extends ImageView {
    private static final String TAG = "CIRCLE_IMAGE_VIEW";
    private boolean hasBorder;
    private float borderWidth;
    private int borderColor;
    private int selectedColor;
    private boolean isSelected;
    private Paint paint;
    private Paint borderPaint;
    private Paint backgroundPaint;
    private Bitmap image;
    private int minCanvasSide;
    private BitmapShader shader;
    private ItemSelectedListener listener;

    public CircleImageView(Context context) {
        this(context, null, R.styleable.CircleImageViewStyle_circleImageViewDefault);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.styleable.CircleImageViewStyle_circleImageViewDefault);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        this.paint = new Paint();
        this.borderPaint = new Paint();
        this.backgroundPaint = new Paint();
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyle, 0);
        int backgroundColor = attributes.getColor(R.styleable.CircleImageView_view_backgroundColor, 17170445);
        this.hasBorder = attributes.getBoolean(R.styleable.CircleImageView_view_border, false);
        this.borderColor = attributes.getColor(R.styleable.CircleImageView_view_borderColor, 17170443);
        this.borderWidth = attributes.getDimension(R.styleable.CircleImageView_view_borderWidth, 2.0f);
        this.selectedColor = attributes.getColor(R.styleable.CircleImageView_view_selectedColor, 17170443);
        this.setBackgroundColor(backgroundColor);
        if (this.hasBorder) {
            this.setBorderWidth(this.borderWidth);
            this.setBorderColor(this.borderColor);
        }
        this.paint.setAntiAlias(true);
        this.borderPaint.setAntiAlias(true);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.backgroundPaint.setAntiAlias(true);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        attributes.recycle();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        float radius;
        int oldCanvasSize = this.minCanvasSide;
        int n = this.minCanvasSide = this.getMeasuredWidth() < this.getMeasuredHeight() ? this.getMeasuredWidth() : this.getMeasuredHeight();
        if (oldCanvasSize != this.minCanvasSide) {
            this.updateBitmapShader();
        }
        this.paint.setShader((Shader)this.shader);
        int centerX = this.getMeasuredWidth() / 2;
        int centerY = this.getMeasuredHeight() / 2;
        if (this.hasBorder && !this.isSelected) {
            this.setBorderColor(this.borderColor);
            radius = ((float)this.minCanvasSide - this.borderWidth) / 2.0f;
            RectF rect = new RectF(0.0f + this.borderWidth / 2.0f, 0.0f + this.borderWidth / 2.0f, (float)this.minCanvasSide - this.borderWidth / 2.0f, (float)this.minCanvasSide - this.borderWidth / 2.0f);
            canvas.drawArc(rect, 360.0f, 360.0f, false, this.borderPaint);
        } else if (this.hasBorder) {
            this.setBorderColor(this.selectedColor);
            radius = ((float)this.minCanvasSide - this.borderWidth) / 2.0f;
            RectF rect = new RectF(0.0f + this.borderWidth / 2.0f, 0.0f + this.borderWidth / 2.0f, (float)this.minCanvasSide - this.borderWidth / 2.0f, (float)this.minCanvasSide - this.borderWidth / 2.0f);
            canvas.drawArc(rect, 360.0f, 360.0f, false, this.borderPaint);
        } else {
            radius = this.minCanvasSide / 2;
        }
        canvas.drawCircle((float)centerX, (float)centerY, radius, this.backgroundPaint);
        canvas.drawCircle((float)centerX, (float)centerY, radius, this.paint);
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (!this.isClickable()) {
            this.isSelected = false;
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                boolean bl = this.isSelected = !this.isSelected;
                if (this.isSelected && this.listener != null) {
                    this.listener.onSelected((View)this);
                    break;
                }
                if (this.isSelected || this.listener == null) break;
                this.listener.onUnselected((View)this);
            }
        }
        this.invalidate();
        return super.dispatchTouchEvent(event);
    }

    public void setOnItemSelectedClickListener(ItemSelectedListener listener) {
        this.listener = listener;
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.backgroundPaint != null) {
            this.backgroundPaint.setColor(backgroundColor);
        }
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        if (this.borderPaint != null) {
            this.borderPaint.setColor(borderColor);
        }
        this.invalidate();
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        if (this.borderPaint != null) {
            this.borderPaint.setStrokeWidth(borderWidth);
        }
        this.requestLayout();
        this.invalidate();
    }

    public Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            Log.i((String)TAG, (String)"Bitmap drawable!");
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int intrinsicWidth = drawable.getIntrinsicWidth();
        int intrinsicHeight = drawable.getIntrinsicHeight();
        if (intrinsicWidth <= 0 || intrinsicHeight <= 0) {
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)intrinsicWidth, (int)intrinsicHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"Encountered OutOfMemoryError while generating bitmap!");
            return null;
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.image = this.drawableToBitmap(this.getDrawable());
        if (this.minCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.image = this.drawableToBitmap(this.getDrawable());
        if (this.minCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.image = this.drawableToBitmap(this.getDrawable());
        if (this.minCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.image = bm;
        if (this.minCanvasSide > 0) {
            this.updateBitmapShader();
        }
    }

    public void updateBitmapShader() {
        if (this.image == null) {
            return;
        }
        this.shader = new BitmapShader(this.image, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (this.minCanvasSide != this.image.getWidth() || this.minCanvasSide != this.image.getHeight()) {
            Matrix matrix = new Matrix();
            float scale = (float)this.minCanvasSide / (float)this.image.getWidth();
            matrix.setScale(scale, scale);
            this.shader.setLocalMatrix(matrix);
        }
    }
}

