/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.alexvasilkov.gestures.GestureController;
import com.alexvasilkov.gestures.GestureControllerForPager;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.internal.DebugOverlay;
import com.alexvasilkov.gestures.internal.GestureDebug;
import com.alexvasilkov.gestures.utils.ClipHelper;
import com.alexvasilkov.gestures.utils.CropUtils;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;
import com.alexvasilkov.gestures.views.interfaces.ClipBounds;
import com.alexvasilkov.gestures.views.interfaces.ClipView;
import com.alexvasilkov.gestures.views.interfaces.GestureView;

public class GestureImageView
extends ImageView
implements GestureView,
ClipView,
ClipBounds,
AnimatorView {
    private GestureControllerForPager controller;
    private final ClipHelper clipViewHelper = new ClipHelper((View)this);
    private final ClipHelper clipBoundsHelper = new ClipHelper((View)this);
    private final Matrix imageMatrix = new Matrix();
    private ViewPositionAnimator positionAnimator;

    public GestureImageView(Context context) {
        this(context, null, 0);
    }

    public GestureImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GestureImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.ensureControllerCreated();
        this.controller.getSettings().initFromAttributes(context, attrs);
        this.controller.addOnStateChangeListener(new GestureController.OnStateChangeListener(){

            @Override
            public void onStateChanged(State state) {
                GestureImageView.this.applyState(state);
            }

            @Override
            public void onStateReset(State oldState, State newState) {
                GestureImageView.this.applyState(newState);
            }
        });
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    private void ensureControllerCreated() {
        if (this.controller == null) {
            this.controller = new GestureControllerForPager((View)this);
        }
    }

    public void draw(@NonNull Canvas canvas) {
        this.clipBoundsHelper.onPreDraw(canvas);
        this.clipViewHelper.onPreDraw(canvas);
        super.draw(canvas);
        this.clipViewHelper.onPostDraw(canvas);
        this.clipBoundsHelper.onPostDraw(canvas);
        if (GestureDebug.isDrawDebugOverlay()) {
            DebugOverlay.drawDebug((View)this, canvas);
        }
    }

    @Override
    public GestureControllerForPager getController() {
        return this.controller;
    }

    @Override
    public ViewPositionAnimator getPositionAnimator() {
        if (this.positionAnimator == null) {
            this.positionAnimator = new ViewPositionAnimator(this);
        }
        return this.positionAnimator;
    }

    @Override
    public void clipView(@Nullable RectF rect, float rotation) {
        this.clipViewHelper.clipView(rect, rotation);
    }

    @Override
    public void clipBounds(@Nullable RectF rect) {
        this.clipBoundsHelper.clipView(rect, 0.0f);
    }

    @Deprecated
    public void getSnapshot(OnSnapshotLoadedListener listener) {
        if (this.getDrawable() != null) {
            listener.onSnapshotLoaded(this.crop());
        }
    }

    @Nullable
    public Bitmap crop() {
        return CropUtils.crop(this.getDrawable(), this.controller);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.controller.onTouch((View)this, event);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.controller.getSettings().setViewport(width - this.getPaddingLeft() - this.getPaddingRight(), height - this.getPaddingTop() - this.getPaddingBottom());
        this.controller.resetState();
    }

    public void setImageResource(int resId) {
        this.setImageDrawable(GestureImageView.getDrawable(this.getContext(), resId));
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.ensureControllerCreated();
        Settings settings = this.controller.getSettings();
        float oldWidth = settings.getImageW();
        float oldHeight = settings.getImageH();
        if (drawable == null) {
            settings.setImage(0, 0);
        } else if (drawable.getIntrinsicWidth() == -1 || drawable.getIntrinsicHeight() == -1) {
            settings.setImage(settings.getMovementAreaW(), settings.getMovementAreaH());
        } else {
            settings.setImage(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        }
        float newWidth = settings.getImageW();
        float newHeight = settings.getImageH();
        if (newWidth > 0.0f && newHeight > 0.0f && oldWidth > 0.0f && oldHeight > 0.0f) {
            float scaleFactor = Math.min(oldWidth / newWidth, oldHeight / newHeight);
            this.controller.getStateController().setTempZoomPatch(scaleFactor);
            this.controller.updateState();
            this.controller.getStateController().setTempZoomPatch(0.0f);
        } else {
            this.controller.resetState();
        }
    }

    protected void applyState(State state) {
        state.get(this.imageMatrix);
        this.setImageMatrix(this.imageMatrix);
    }

    private static Drawable getDrawable(Context context, @DrawableRes int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(id);
        }
        return context.getResources().getDrawable(id);
    }

    @Deprecated
    public static interface OnSnapshotLoadedListener {
        public void onSnapshotLoaded(Bitmap var1);
    }
}

