/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.alexvasilkov.gestures.GestureController;
import com.alexvasilkov.gestures.GestureControllerForPager;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.internal.DebugOverlay;
import com.alexvasilkov.gestures.internal.GestureDebug;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;
import com.alexvasilkov.gestures.views.interfaces.GestureView;

public class GestureFrameLayout
extends FrameLayout
implements GestureView,
AnimatorView {
    private final GestureControllerForPager controller;
    private ViewPositionAnimator positionAnimator;
    private final Matrix matrix = new Matrix();
    private final Matrix matrixInverse = new Matrix();
    private final RectF tmpFloatRect = new RectF();
    private final float[] tmpPointArray = new float[2];
    private MotionEvent currentMotionEvent;

    public GestureFrameLayout(Context context) {
        this(context, null, 0);
    }

    public GestureFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GestureFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.controller = new GestureControllerForPager((View)this);
        this.controller.getSettings().initFromAttributes(context, attrs);
        this.controller.addOnStateChangeListener(new GestureController.OnStateChangeListener(){

            @Override
            public void onStateChanged(State state) {
                GestureFrameLayout.this.applyState(state);
            }

            @Override
            public void onStateReset(State oldState, State newState) {
                GestureFrameLayout.this.applyState(newState);
            }
        });
    }

    @Override
    public GestureControllerForPager getController() {
        return this.controller;
    }

    @Override
    public ViewPositionAnimator getPositionAnimator() {
        if (this.positionAnimator == null) {
            this.positionAnimator = new ViewPositionAnimator(this);
        }
        return this.positionAnimator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        this.currentMotionEvent = event;
        MotionEvent invertedEvent = this.applyMatrix(event, this.matrixInverse);
        try {
            boolean bl = super.dispatchTouchEvent(invertedEvent);
            return bl;
        }
        finally {
            invertedEvent.recycle();
        }
    }

    public ViewParent invalidateChildInParent(int[] location, @NonNull Rect dirty) {
        this.applyMatrix(dirty, this.matrix);
        return super.invalidateChildInParent(location, dirty);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.controller.onInterceptTouch((View)this, this.currentMotionEvent);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.controller.onTouch((View)this, this.currentMotionEvent);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.controller.getSettings().setViewport(width - this.getPaddingLeft() - this.getPaddingRight(), height - this.getPaddingTop() - this.getPaddingBottom());
        this.controller.updateState();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        View view = child = this.getChildCount() == 0 ? null : this.getChildAt(0);
        if (child != null) {
            this.controller.getSettings().setImage(child.getMeasuredWidth(), child.getMeasuredHeight());
            this.controller.updateState();
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int extraW = this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed;
        int extraH = this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin + heightUsed;
        child.measure(GestureFrameLayout.getChildMeasureSpecFixed(parentWidthMeasureSpec, extraW, lp.width), GestureFrameLayout.getChildMeasureSpecFixed(parentHeightMeasureSpec, extraH, lp.height));
    }

    protected void applyState(State state) {
        state.get(this.matrix);
        this.matrix.invert(this.matrixInverse);
        this.invalidate();
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        canvas.save();
        canvas.concat(this.matrix);
        super.dispatchDraw(canvas);
        canvas.restore();
        if (GestureDebug.isDrawDebugOverlay()) {
            DebugOverlay.drawDebug((View)this, canvas);
        }
    }

    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams params) {
        if (this.getChildCount() != 0) {
            throw new IllegalArgumentException("GestureFrameLayout can contain only one child");
        }
        super.addView(child, index, params);
    }

    private MotionEvent applyMatrix(MotionEvent event, Matrix matrix) {
        this.tmpPointArray[0] = event.getX();
        this.tmpPointArray[1] = event.getY();
        matrix.mapPoints(this.tmpPointArray);
        MotionEvent copy = MotionEvent.obtain((MotionEvent)event);
        copy.setLocation(this.tmpPointArray[0], this.tmpPointArray[1]);
        return copy;
    }

    private void applyMatrix(Rect rect, Matrix matrix) {
        this.tmpFloatRect.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        matrix.mapRect(this.tmpFloatRect);
        rect.set(Math.round(this.tmpFloatRect.left), Math.round(this.tmpFloatRect.top), Math.round(this.tmpFloatRect.right), Math.round(this.tmpFloatRect.bottom));
    }

    protected static int getChildMeasureSpecFixed(int spec, int extra, int childDimension) {
        if (childDimension == -2) {
            return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)spec), (int)0);
        }
        return GestureFrameLayout.getChildMeasureSpec((int)spec, (int)extra, (int)childDimension);
    }
}

