/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.utils;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.Size;
import com.alexvasilkov.gestures.State;

public class MathUtils {
    private static final Matrix tmpMatrix = new Matrix();
    private static final Matrix tmpMatrixInverse = new Matrix();

    private MathUtils() {
    }

    public static float restrict(float value, float minValue, float maxValue) {
        return Math.max(minValue, Math.min(value, maxValue));
    }

    public static float interpolate(float start, float end, float factor) {
        return start + (end - start) * factor;
    }

    public static void interpolate(RectF out, RectF start, RectF end, float factor) {
        out.left = MathUtils.interpolate(start.left, end.left, factor);
        out.top = MathUtils.interpolate(start.top, end.top, factor);
        out.right = MathUtils.interpolate(start.right, end.right, factor);
        out.bottom = MathUtils.interpolate(start.bottom, end.bottom, factor);
    }

    public static void interpolate(State out, State start, State end, float factor) {
        MathUtils.interpolate(out, start, start.getX(), start.getY(), end, end.getX(), end.getY(), factor);
    }

    public static void interpolate(State out, State start, float startPivotX, float startPivotY, State end, float endPivotX, float endPivotY, float factor) {
        out.set(start);
        if (!State.equals(start.getZoom(), end.getZoom())) {
            float zoom = MathUtils.interpolate(start.getZoom(), end.getZoom(), factor);
            out.zoomTo(zoom, startPivotX, startPivotY);
        }
        float startRotation = start.getRotation();
        float endRotation = end.getRotation();
        float rotation = Float.NaN;
        if (Math.abs(startRotation - endRotation) <= 180.0f) {
            if (!State.equals(startRotation, endRotation)) {
                rotation = MathUtils.interpolate(startRotation, endRotation, factor);
            }
        } else {
            float endRotationPositive;
            float startRotationPositive = startRotation < 0.0f ? startRotation + 360.0f : startRotation;
            float f = endRotationPositive = endRotation < 0.0f ? endRotation + 360.0f : endRotation;
            if (!State.equals(startRotationPositive, endRotationPositive)) {
                rotation = MathUtils.interpolate(startRotationPositive, endRotationPositive, factor);
            }
        }
        if (!Float.isNaN(rotation)) {
            out.rotateTo(rotation, startPivotX, startPivotY);
        }
        float dx = MathUtils.interpolate(0.0f, endPivotX - startPivotX, factor);
        float dy = MathUtils.interpolate(0.0f, endPivotY - startPivotY, factor);
        out.translateBy(dx, dy);
    }

    public static void computeNewPosition(@Size(value=2L) float[] point, State initialState, State finalState) {
        initialState.get(tmpMatrix);
        tmpMatrix.invert(tmpMatrixInverse);
        tmpMatrixInverse.mapPoints(point);
        finalState.get(tmpMatrix);
        tmpMatrix.mapPoints(point);
    }
}

