/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.utils;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.Gravity;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;

public class GravityUtils {
    private static final Matrix tmpMatrix = new Matrix();
    private static final RectF tmpRectF = new RectF();
    private static final Rect tmpRect1 = new Rect();
    private static final Rect tmpRect2 = new Rect();

    private GravityUtils() {
    }

    public static void getImagePosition(State state, Settings settings, Rect out) {
        state.get(tmpMatrix);
        GravityUtils.getImagePosition(tmpMatrix, settings, out);
    }

    public static void getImagePosition(Matrix matrix, Settings settings, Rect out) {
        tmpRectF.set(0.0f, 0.0f, (float)settings.getImageW(), (float)settings.getImageH());
        matrix.mapRect(tmpRectF);
        int w = Math.round(tmpRectF.width());
        int h = Math.round(tmpRectF.height());
        tmpRect1.set(0, 0, settings.getViewportW(), settings.getViewportH());
        Gravity.apply((int)settings.getGravity(), (int)w, (int)h, (Rect)tmpRect1, (Rect)out);
    }

    public static void getMovementAreaPosition(Settings settings, Rect out) {
        tmpRect1.set(0, 0, settings.getViewportW(), settings.getViewportH());
        Gravity.apply((int)settings.getGravity(), (int)settings.getMovementAreaW(), (int)settings.getMovementAreaH(), (Rect)tmpRect1, (Rect)out);
    }

    public static void getDefaultPivot(Settings settings, Point out) {
        GravityUtils.getMovementAreaPosition(settings, tmpRect2);
        Gravity.apply((int)settings.getGravity(), (int)0, (int)0, (Rect)tmpRect2, (Rect)tmpRect1);
        out.set(GravityUtils.tmpRect1.left, GravityUtils.tmpRect1.top);
    }
}

