/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.utils;

import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;

public class FloatScroller {
    private static final long DEFAULT_DURATION = 250L;
    private final Interpolator interpolator = new AccelerateDecelerateInterpolator();
    private boolean finished = true;
    private float startValue;
    private float finalValue;
    private float currValue;
    private long startRtc;
    private long duration = 250L;

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void forceFinished() {
        this.finished = true;
    }

    public void abortAnimation() {
        this.finished = true;
        this.currValue = this.finalValue;
    }

    public void startScroll(float startValue, float finalValue) {
        this.finished = false;
        this.startRtc = SystemClock.elapsedRealtime();
        this.startValue = startValue;
        this.finalValue = finalValue;
        this.currValue = startValue;
    }

    public boolean computeScroll() {
        if (this.finished) {
            return false;
        }
        long elapsed = SystemClock.elapsedRealtime() - this.startRtc;
        if (elapsed >= this.duration) {
            this.finished = true;
            this.currValue = this.finalValue;
            return false;
        }
        float time = this.interpolator.getInterpolation((float)elapsed / (float)this.duration);
        this.currValue = FloatScroller.interpolate(this.startValue, this.finalValue, time);
        return true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public float getStart() {
        return this.startValue;
    }

    public float getFinal() {
        return this.finalValue;
    }

    public float getCurr() {
        return this.currValue;
    }

    private static float interpolate(float x1, float x2, float state) {
        return x1 + (x2 - x1) * state;
    }
}

